package com.digiwin.athena.cdme.core.aop;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author zhangww
 * @description:
 * @date 2023/3/3 17:04
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ExceptionRetry {
    /**
     * 重试次数
     *
     * @return
     */
    int times() default 1;

    /**
     * 重试等待时间 单位ms
     *
     * @return
     */
    long waitTime() default 100;

}
