package com.digiwin.athena.cdme.core.aop;

import org.apache.logging.log4j.ThreadContext;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * 生成traceId切面类
 *
 * @author dongwh
 * @date 2021-09-08 15:19
 */
@Aspect
@Component("cdmeTraceIdAspect")
public class TraceIdAspect {
    /**
     * 生成traceId
     *
     * @param traceIdAnnotation
     * @return
     */
    @Before("@annotation(traceIdAnnotation)")
    public void processTrace(TraceId traceIdAnnotation) {
        /** 生成traceId并放入容器上下文中 **/
        ThreadContext.put("traceId", UUID.randomUUID().toString().replaceAll("-", ""));
    }
}