package com.digiwin.athena.cdme.core.base;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * @description: 标准的crud定义
 * @author: liunansheng
 * @date: 2022/3/9 16:48
 */
public interface IRepositoryService<T> {
    /**
     * 插入一条记录，插入非null字段
     * @param entity 实体对象
     */
    boolean save(T entity);

    /**
     * 根据 ID 删除
     * @param id 主键ID
     */
    boolean deleteById(Serializable id);
    /**
     * 删除（根据ID 批量删除）
     * @param idList 主键ID列表(不能为 null 以及 empty)
     */
    boolean deleteBatchIds(Collection<? extends Serializable> idList);
    /**
     * 根据 ID 修改，只修改非null字段
     * @param entity 实体对象
     */
    boolean edit(T entity);
    /**
     * 根据 ID 查询
     * @param id 主键ID
     */
    T getById(Serializable id);

    /**
     * 查询（根据ID 批量查询）
     * @param idList 主键ID列表(不能为 null 以及 empty)
     */
    List<T> listByBatchIds(Collection<? extends Serializable> idList);

}
