package com.digiwin.athena.cdme.core.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 错误码枚举
 * @author: liunansheng
 * @date: 2022/9/5 17:35
 */
public enum  ErrorCodeEnum {
    ROUTE_KEY_EMPTY("P.ME.201.0001", "routeKey为空"),
    RULE_UN_SYNCHRONIZED("P.ME.200.0002","侦测规则未同步"),
    RULE_SCHEDULE_EMPTY("P.ME.200.0003","侦测规则未配置排程"),
    RULE_NOT_EXISTS("P.ME.200.0004","没有匹配到正在运行中的侦测"),
    UNKONW_CATEGORY("P.ME.200.0005","侦测方式配置错误"),
    TRIGGER_NOT_EXISTS("P.ME.200.0006","没有匹配的侦测排程信息"),
    LAST_MONITOR_TIME_AFTER_NOW("P.ME.200.0007","上次侦测时间晚于当前时间"),
    DYNAMIC_RULE_ILLEGAL("P.ME.200.0008","侦测规则配置错误"),
    DISABLED_RULE_FAIL("P.ME.200.0009","停用规则失败"),
    DIGI_SERVICE_EMPTY("P.ME.200.0010","digi-service中节点内容为空，请查看！"),
    DIGI_SERVICE_WRONG("P.ME.200.0011","digi-service中prod或者id值与注册不一致，请查看！"),
    DIGI_SERVICE_TENANT_ID_EMPTY("P.ME.200.0012","digi-service中租户Id为空，请查看！"),
    REPORT_PARAM_ERR("P.ME.200.0013","侦测规则传值为空, 请查看!"),
    REPORT_DATA_EMPTY("P.ME.200.0014","REPORT类型变更数据为空,无需发起!"),
    REPORT_ALL_FAILE("P.ME.200.0015","REPORT类型分页发起执行全部失败，请查看！"),
    REPORT_PART_FAILE("P.ME.200.0016","REPORT类型分页发起执行部分失败，请查看"),
    SCHEDULE_NOT_EXIST("P.ME.200.0017","查询不到匹配的排程信息"),
    SCHEDULE_IS_ENABLED("P.ME.200.0018","该排程实例状态为启用"),
    RULE_SCHEDULE_SYNC_FAILED("P.ME.200.0019", "规则排程同步处理失败"),
    DATA_CHANGE_GET_RES_EMPTY("P.ME.200.0020", "ESP调用成功,但返回response_objects节点数据为空！"),
    SCHEDULE_MONITOR_FAIL("P.ME.200.0021", "SCHEDULE类型侦测发起失败"),
    UNKNOW_ERR("P.ME.200.0022", "系统出现未知异常"),
    EOC_NOT_MATCH("P.ME.200.0023", "没有匹配的eoc信息"),
    CROSS_LEVEL_TENANT_LEVEL_ERR("P.ME.200.0024", "新的EOC侦测规则层级不能为租户级别!"),
    CROSS_LEVEL_NEW_GRETTER_OLD_ERR("P.ME.200.0025", "新的EOC侦测规则层级不能大于老的EOC侦测规则层级!"),
    CROSS_LEVEL_NEW_EOC_NOT_MATCH("P.ME.200.0026", "新的EOC运营单元数据与老运营单元数据不一致!"),
    CROSS_LEVEL_NEW_EOC_EMPTY("P.ME.200.0027", "新的EOC不允许为空!"),
    CROSS_LEVEL_UNSUPPORTED_REPORT("P.ME.200.0028", "跨层级更新侦测规则暂不支持REPORT类型!"),
    RULE_ALREADY_EXISTS("P.ME.200.0029", "参数对应的侦测规则信息已存在!"),
    CREATE_RULE_LEVEL_NOT_MATCH("P.ME.200.0031", "规则层级与现有存在层级不一致，规则同步失败！"),
    PARAM_EMPTY_ERR("P.ME.200.0032", "必填参数为空"),
    NOT_TEST_TENANT("P.ME.200.0033", "非测试租户，不允许此操作！"),
    TOKEN_NOT_MATCH_TENANT_ID("P.ME.200.0034", "租户id和token不一致，请查看！"),
    SECURE_ERR("P.ME.200.0035", "secure为空或不正确，请检查！"),
    DETECT_IMMEDIATELY_EVENT_ERR("P.ME.200.0036", "创建规则后立即发起侦测事件执行异常"),
    AFTER_CREATE_EVENT_ERR("P.ME.200.0037", "规则创建后事件处理失败"),
    RULE_SYNC_TYPE_ERR("P.ME.200.0038", "ChangeType传入错误"),
    CALCULATE_TIME_WINDOW_FAIL("P.ME.200.0039","计算侦测时间窗口失败"),
    DYNAMIC_RULE_CONFIG_ERR("P.ME.200.0040","动态参数配置错误"),
    DETECT_DATA_UNDEFINED("P.ME.200.0041","侦测返回结果非定义处理类型,侦测流程结束"),
    DETECTION_ALL_FAILE("P.ME.200.0042","分页发起执行全部失败，请查看！"),
    DETECTION_PART_FAILE("P.ME.200.0043","分页发起执行部分失败，请查看"),
    DETECTION_INTERVAL_LIMIT("P.ME.200.0044","侦测正在发起中"),
    ROUTER_DELIVER_ERR("P.ME.200.0045", "路由转发失败"),
    SAVE_RECORD_FAIL("P.ME.300.0001","侦测执行记录入库失败"),
    SAVE_DUP_FAIL("P.ME.300.0002","去重缓存入库失败"),
    CLEAN_DUP_FAIL("P.ME.300.0003","清除去重缓存失败"),
    SAVE_INS_FAIL("P.ME.300.0004","侦测更新时间窗口失败"),
    GET_DISPATCH_504("P.ME.504.0001","获取dispatch失败，调用超时"),
    GET_DISPATCH_503("P.ME.503.0001","获取dispatch失败，服务不可用"),
    GET_DISPATCH_502("P.ME.502.0001","获取dispatch失败，服务不可用"),
    GET_DISPATCH_500("P.ME.500.0001","获取dispatch失败，服务异常"),
    GET_DISPATCH_400("P.ME.400.0001","获取dispatch失败，返回数据格式非法"),
    GET_DISPATCH_OTHER_ERR("P.ME.401.0001","获取dispatch发生未知网络异常"),
    DATA_CHANGE_GET_504("P.ME.504.0002","调用ESP获取变化数据失败，调用超时"),
    DATA_CHANGE_GET_503("P.ME.503.0002","调用ESP获取变化数据失败，服务不可用"),
    DATA_CHANGE_GET_502("P.ME.502.0002","调用ESP获取变化数据失败，服务不可用"),
    DATA_CHANGE_GET_500("P.ME.500.0002","调用ESP获取变化数据失败，服务异常"),
    DATA_CHANGE_GET_400("P.ME.400.0002","调用ESP获取变化数据失败，返回数据格式非法"),
    DATA_CHANGE_GET_OTHER_ERR("P.ME.401.0002","调用ESP获取变化发生未知网络异常"),
    EE_504("P.ME.504.0003","调用执行引擎失败，调用超时"),
    EE_503("P.ME.503.0003","调用执行引擎失败，服务不可用"),
    EE_502("P.ME.502.0003","调用执行引擎失败，服务不可用"),
    EE_500("P.ME.500.0003","调用执行引擎失败，服务异常"),
    EE_400("P.ME.400.0003","调用执行引擎失败，返回数据格式非法"),
    EE_OTHER_ERR("P.ME.401.0003","调用执行引擎发生未知网络异常"),
    IAM_504("P.ME.504.0004","调用IAM失败，调用超时"),
    IAM_503("P.ME.503.0004","调用IAM失败，服务不可用"),
    IAM_502("P.ME.502.0004","调用IAM失败，服务不可用"),
    IAM_500("P.ME.500.0004","调用IAM失败，服务异常"),
    IAM_GET_TOKEN_EMPTY("P.ME.400.1004","根据secretKey获取token失败，返回结果为空"),
    IAM_OTHER_ERR("P.ME.401.0004","调用执行引擎发生未知网络异常"),
    KG_504("P.ME.504.0005","调用KG失败，调用超时"),
    KG_503("P.ME.503.0005","调用KG失败，服务不可用"),
    KG_502("P.ME.502.0005","调用KG失败，服务不可用"),
    KG_500("P.ME.500.0005","调用KG失败，服务异常"),
    KG_400("P.ME.400.0005","调用KG失败，返回数据格式非法"),
    KG_OTHER_ERR("P.ME.401.0005","调用KG发生未知网络异常"),
    SCHEDULE_504("P.ME.504.0006","调用排程引擎失败，调用超时"),
    SCHEDULE_503("P.ME.503.0006","调用排程引擎失败，服务不可用"),
    SCHEDULE_502("P.ME.502.0006","调用排程引擎失败，服务不可用"),
    SCHEDULE_500("P.ME.500.0006","调用排程引擎失败，服务异常"),
    SCHEDULE_OTHER_ERR("P.ME.401.0006","调用排程引擎发生未知网络异常"),
    SCWOKER_504("P.ME.504.0007","调用服务编排失败，调用超时"),
    SCWOKER_503("P.ME.503.0007","调用服务编排失败，服务不可用"),
    SCWOKER_502("P.ME.502.0007","调用服务编排失败，服务不可用"),
    SCWOKER_500("P.ME.500.0007","调用服务编排失败，服务异常"),
    SCWOKER_400("P.ME.400.0007","调用服务编排失败，返回数据格式非法"),
    SCWOKER_OTHER_ERR("P.ME.401.0007","调用服务编排发生未知网络异常"),
    TASK_504("P.ME.504.0008","调用任务引擎失败，调用超时"),
    TASK_503("P.ME.503.0008","调用任务引擎失败，服务不可用"),
    TASK_502("P.ME.502.0008","调用任务引擎失败，服务不可用"),
    TASK_500("P.ME.500.0008","调用任务引擎失败，服务异常"),
    TASK_400("P.ME.400.0008","调用任务引擎失败，返回数据格式非法"),
    TASK_OTHER_ERR("P.ME.401.0008","调用任务引擎发生未知网络异常"),
    CDME_504("P.ME.504.0009","调用CDME引擎失败，调用超时"),
    CDME_503("P.ME.503.0009","调用CDME引擎失败，服务不可用"),
    CDME_502("P.ME.502.0009","调用CDME引擎失败，服务不可用"),
    CDME_500("P.ME.500.0009","调用CDME引擎失败，服务异常"),
    CDME_400("P.ME.400.0009","调用CDME引擎失败，返回数据格式非法"),
    CDME_OTHER_ERR("P.ME.401.0009","调用CDME引擎发生未知网络异常"),
    ;

    ErrorCodeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private String code;

    private String message;

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static void main(String[] args) {
        List<String> properties = new ArrayList<>();
        for (ErrorCodeEnum codeEnum : ErrorCodeEnum.values()) {
            properties.add(codeEnum.getCode() + "=" + codeEnum.getMessage());
        }
        for (SuccessMessageEnum codeEnum : SuccessMessageEnum.values()) {
            properties.add(codeEnum.getCode() + "=" + codeEnum.getMessage());
        }
        System.out.println(String.join("\n", properties));
    }
}
