package com.digiwin.athena.cdme.core.enums;

/**
 * @description: 运维接口返回信息
 * @author: renwm
 * @date: 2020/5/9 9:09
 */
public enum MonitorOpsMonitorStatusEnum {

    /** 侦测状态信息 start*/
    /*侦测: 第一位：是否有侦测,第二位：是否成功侦测,第三位：是否侦测有返回值*/
    MONITOR_STATUS_000("000", "没有侦测"),
    MONITOR_STATUS_100("100", "有侦测，侦测失败，没有返回值"),
    MONITOR_STATUS_110("110", "有侦测，侦测成功，没有返回值"),
    MONITOR_STATUS_111("111", "有侦测，侦测成功且有返回值");
    /** 侦测状态信息 end*/

    private final String type;
    private final String desc;

    MonitorOpsMonitorStatusEnum(String type, String desc) {
        this.desc = desc;
        this.type = type;
    }

    public static String getEnumByType(String type) {
        for (MonitorOpsMonitorStatusEnum itemEnum : MonitorOpsMonitorStatusEnum.values()) {
            if (itemEnum.getType().equals(type)) {
                return itemEnum.getDesc();
            }
        }
        return "";
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
