package com.digiwin.athena.cdme.core.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;

/**
 * @description: 适用于调用第三方组件返回异常的场景。例如：HTTP调用状态码（4xx，5xx）异常，RPC调用异常等。
 * @author: dongwh
 * @date: 2022/1/6 15:02
 */
public class ResponseStatusException extends DWRuntimeException implements Retryable {

    /**
     * 构造一个基本异常.
     * @param errorCodeEnum 错误码枚举
     */
    public ResponseStatusException(ErrorCodeEnum errorCodeEnum) {
        super(errorCodeEnum.getCode(), errorCodeEnum.getMessage());
    }

    /**
     * 构造一个基本异常.
     * @param errorCodeEnum 错误码枚举
     * @param cause 异常
     */
    public ResponseStatusException(ErrorCodeEnum errorCodeEnum, Throwable cause) {
        super(errorCodeEnum.getCode(), errorCodeEnum.getMessage(), cause);
    }

    @Override
    public String getErrorType() {
        return "application";
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     */
    public ResponseStatusException(String message) {
        super(message);
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     * @param cause   根异常类（可以存入任何异常）
     */
    public ResponseStatusException(String message, Throwable cause) {
        super(message, cause);
    }
}
