package com.digiwin.athena.cdme.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.constant.FieldValConstant;

/**
 * @description: 服务返回结果处理类
 * @author: renwm
 * @date: 2020/6/8 17:26
 */
public final class ServiceResponseUtil {
    private ServiceResponseUtil() {
    }

    /**
     * 获取执行引擎响应结果
     *
     * @param respContent
     * @return
     */
    public static JSON parseExecutionRespData(String respContent) {
        JSONObject respObject = JsonUtil.getObject(respContent);
        if (CollectionUtil.isNotEmpty(respObject) && FieldValConstant.RESPONSE_SUCCESS_CODE == respObject.getIntValue(FieldConstant.DW_SERVICE_STATUS)) {
            return (JSON) respObject.get(FieldConstant.DW_SERVICE_RESPONSE);
        }
        return null;
    }


    public static JSONObject checkObjEmpty(JSONObject paramObj) {
        if (CollectionUtil.isEmpty(paramObj)) {
            return null;
        }
        return paramObj;
    }

}
