package com.digiwin.athena.cdme.core.util;

/**
 * String操作工具类
 *
 * @author zhangzhi@digiwin.com
 * @date 2020/7/17
 */
public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isBlank(String string) {
        return nullToEmpty(string).trim().isEmpty();
    }

    public static boolean isNotBlank(String string) {
        return !isBlank(string);
    }

    public static String trimToEmpty(String string) {
        return string == null ? "" : string.trim();
    }

    public static String trimToNull(String string) {
        if (null == string) {
            return null;
        }
        string = string.trim();
        return  string.isEmpty() ? null : string;
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static String emptyToNull(String string) {
        return isBlank(string) ? null : string;
    }

    public static boolean isEmpty(String string) {
        return nullToEmpty(string).isEmpty();
    }

    /**
     * 给数字补位，不够前面补0
     * @param num
     * @param length 补齐后位数
     * @return
     */
    public static String padWithZero(int num, int length) {
        String str = String.valueOf(num);
        if (str.length() >= length) {
            return str;
        }
        return String.format("%0".concat(String.valueOf(length)).concat("d"), num);
    }
}
