package com.digiwin.athena.cdme.mq.consumer.monitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorFacadeService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

/**
 * @author yangxiao
 * @description: 监听BM_OPSC_CDC Topic的侦测消息
 * @date 2023/12/6 16:10
 */
@Component("cdmeMonitorTransferOpscCdcListener")
public class MonitorTransferOpscCdcListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTransferOpscCdcListener.class);

    private final IMonitorFacadeService monitorFacadeService;

    public MonitorTransferOpscCdcListener(IMonitorFacadeService monitorFacadeService) {
        this.monitorFacadeService = monitorFacadeService;
    }

    @KafkaListener(topics = {ConfigConstant.OPSC_CDC_MQ_TOPIC}, groupId = ConfigConstant.CDME_MQ_GROUP, containerFactory = ConfigConstant.CDC_MQ_FACTORY, errorHandler = "cdmeConsumerAwareErrorHandler")
    public void consumeMonitorMsg(ConsumerRecord<?, ?> record, Acknowledgment ack) {
        LOGGER.info("侦测引擎接收CDC的转发消息来自OPSC Topic为:[{}]", record.value());
        JSONObject recordJsonObject = JSON.parseObject(String.valueOf(record.value()));
        ResultDto resultDto = monitorFacadeService.executeDeliver(recordJsonObject);
        if(resultDto.getSuccess()){
            ack.acknowledge();
        }
    }
}
