package com.digiwin.athena.cdme.pojo.dto;

import com.digiwin.athena.cdme.JsonUtil;

/**
 * @description: 消息同步规则
 * @author: dongwh
 * @date: 2021/1/21 10:02
 */
public class SyncRuleParamDto {
    private String transactionId;
    private String tenantId;
    private String ruleId;
    private String changeType;
    private String enableStatus;
    private String backtrackDate;
    private EocDto eocMap;

    public SyncRuleParamDto() {
    }

    public SyncRuleParamDto(String tenantId, String ruleId, String changeType, EocDto eocMap,
                            String enableStatus, String backtrackDate) {
        this(tenantId, ruleId, changeType, eocMap, enableStatus, backtrackDate, null);
    }

    public SyncRuleParamDto(String tenantId, String ruleId, String changeType, EocDto eocMap,
                            String enableStatus, String backtrackDate, String transactionId) {
        this.tenantId = tenantId;
        this.ruleId = ruleId;
        this.changeType = changeType;
        this.eocMap = eocMap;
        this.enableStatus = enableStatus;
        this.backtrackDate = backtrackDate;
        this.transactionId = transactionId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(String enableStatus) {
        this.enableStatus = enableStatus;
    }

    public EocDto getEocMap() {
        return eocMap;
    }

    public void setEocMap(EocDto eocMap) {
        this.eocMap = eocMap;
    }

    public String getBacktrackDate() {
        return backtrackDate;
    }

    public void setBacktrackDate(String backtrackDate) {
        this.backtrackDate = backtrackDate;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
