package com.digiwin.athena.cdme.pojo.dto.parse;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.cdme.JsonUtil;

/**
 * @author zhangzhi@digiwin.com
 * @date 2020/9/30
 */
public class DynamicRuleDto {
    private static final String START_TYPE = "START";

    private String period;
    private long range;
    private String day;
    @JSONField(name = "add_day")
    private long addDay;
    /**
     * 时间类型,用于标记计算是使用开始时间00:00:00.000还是结束时间23.59.59.999
     */
    @JSONField(name = "time_type")
    private String timeType;
    /**
     * 时间格式字段，如果配置了，按配置的格式做格式化
     */
    private String fomart;

    public String getPeriod() {
        return period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public long getRange() {
        return range;
    }

    public void setRange(long range) {
        this.range = range;
    }

    public String getDay() {
        return day;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public long getAddDay() {
        return addDay;
    }

    public void setAddDay(long addDay) {
        this.addDay = addDay;
    }

    public String getTimeType() {
        return timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public boolean isStartType() {
        return START_TYPE.equals(this.timeType);
    }

    public String getFomart() {
        return fomart;
    }

    public void setFomart(String fomart) {
        this.fomart = fomart;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
