package com.digiwin.athena.cdme.provider;

import com.digiwin.athena.cdme.pojo.vo.DeaResultVo;
import com.digiwin.athena.cdme.pojo.request.DeaDataRequest;
import com.digiwin.athena.cdme.service.facade.dea.IDeaFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @author zhangww
 * @description: 通过dea方式查询地端数据
 * @date 2022/7/15 16:35
 */
@Service("cdmeDeaService")
public class DeaService implements IDeaService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DeaService.class);

    private final IDeaFacadeService deaFacadeService;

    public DeaService(IDeaFacadeService deaFacadeService) {
        this.deaFacadeService = deaFacadeService;
    }

    /**
     * 通过dea方式查询数据
     * @param request
     * @return
     */
    @Override
    public DeaResultVo getDataByDea(DeaDataRequest request) {
        LOGGER.info("通过dea方式查询数据：{}", request);
        return deaFacadeService.getDataByDea(request);
    }
}
