package com.digiwin.athena.cdme.provider;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.cdme.pojo.vo.SyncRuleInfoVo;
import java.util.Map;

/**
 * @description: 侦测运维相关接口定义处
 * @author: dongwh
 * @date: 2020/11/4 10:38
 */
public interface IMonitorOpsService extends DWService {

    /**
     * 侦测查询服务接口
     *
     * @param ruleId
     * @param tenantId
     * @param secure
     * @return
     * @throws Exception
     */
    JSONArray postMonitorInfo(String ruleId, String tenantId, Map<String, String> eocMap,
        String secure);

    /**
     * 设置侦测回溯日期
     *
     * @param ruleId
     * @param tenantId
     * @param backtrackDate
     * @param secure
     * @return
     */
    String postBacktrackDate(String ruleId, String tenantId, Map<String, String> eocMap,
        String backtrackDate, String secure);

    /**
     * 设置侦测回溯日期-仅针对测试租户使用
     *
     * @param ruleId
     * @param tenantId
     * @param backtrackDate
     * @return
     */
    String postBacktrackDate(String ruleId, String tenantId, Map<String, String> eocMap,
        String backtrackDate);

    /**
     * 根据测试租户id获取租户token
     *
     * @param tenantId
     * @return
     */
    @AllowAnonymous
    String getTestUserToken(String tenantId);

    /**
     * 根据secure及租户id获取租户token
     * 验证secure合法后返回正确的token
     *
     * @param tenantId
     * @return
     */
    @AllowAnonymous
    String getSecureUserToken(String tenantId, String secure);

    /**
     * 设置分页下发执行的侦测数量 -- 仅针对测试租户使用
     *
     * @param ruleId   规则编号
     * @param tenantId 租户ID
     * @param pageSize 分页下发执行的侦测数量
     * @return
     */
    String postSetPageSize(String ruleId, String tenantId, Map<String, String> eocMap,
        Integer pageSize);

    /**
     * 设置分页下发执行的侦测数量 -- 用于操作所有租户
     *
     * @param ruleId   规则编号
     * @param tenantId 租户ID
     * @param pageSize 分页下发执行的侦测数量
     * @return
     */
    String postSetPageSize(String ruleId, String tenantId, Map<String, String> eocMap,
        Integer pageSize, String secure);

    /**
     * 获取分页下发执行数据量 -- 暂不对对外提供
     *
     * @param ruleId
     * @param tenantId
     */
    Integer postGetPageSize(String ruleId, String tenantId, Map<String, String> eocMap);

    /**
     * 用于ThemeMap通过MQ同步侦测规则后检查同步结果是否成功
     * note 当前租户为测试租户才可以执行此操作
     *
     * @param ruleId
     * @param tenantId
     * @param eocMap
     * @return
     */
    SyncRuleInfoVo postGetMonitorRule(String ruleId, String tenantId, Map<String, String> eocMap);

    /**
     * 用于ThemeMap通过MQ同步侦测规则后检查同步结果是否成功
     * note 验证secure有效后，不区分测试租户还是正式租户，均可以执行此操作。
     *
     * @param ruleId
     * @param tenantId
     * @param eocMap
     * @return
     */
    SyncRuleInfoVo postGetMonitorRule(String ruleId, String tenantId, Map<String, String> eocMap,
        String secure);

}
