package com.digiwin.athena.cdme.provider;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestBody;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.cdme.pojo.request.MqttRequest;

/**
 * @author yang.xiao
 * @version V1.0
 * @Description MQTT运维接口
 * @date 2024/6/25 14:03
 * @Copyright 鼎捷软件股份有限公司
 */
@DWRestfulService
public interface IMqttOpsService extends DWService {

    @DWRequestMapping(path = "/opt/mqtt/conn", method = DWRequestMethod.POST)
    public String connect(@DWRequestBody MqttRequest request);

    @DWRequestMapping(path = "/opt/mqtt/disconn", method = DWRequestMethod.POST)
    public String disconnect(@DWRequestBody MqttRequest request);

    @DWRequestMapping(path = "/opt/mqtt/sub", method = DWRequestMethod.POST)
    public String sub(@DWRequestBody MqttRequest request);

    @DWRequestMapping(path = "/opt/mqtt/unsub", method = DWRequestMethod.POST)
    public String unsub(@DWRequestBody MqttRequest request);
    @DWRequestMapping(path = "/reset/connect", method = DWRequestMethod.POST)
    public void reset(@DWRequestBody MqttRequest request);

    @DWRequestMapping(path = "/init/businessSource", method = DWRequestMethod.POST)
    public void initMqttByBusinessSource(@DWRequestBody String businessSource) throws Exception;
}
