package com.digiwin.athena.cdme.provider;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.core.aop.RouterKey;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.ArgumentValidException;
import com.digiwin.athena.cdme.core.util.SecurityUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.vo.ExistActiveProjectVO;
import com.digiwin.athena.cdme.provider.converter.EocDtoConverter;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.athena.cdme.service.facade.ops.IMonitorValidationFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import org.springframework.stereotype.Service;

/**
 * @description: 检查服务
 * @author: liunansheng
 * @date: 2021/10/22 15:52
 */
@Service("cdmeMonitorValidationService")
public class MonitorValidationService implements IMonitorValidationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorValidationService.class);

    @Autowired
    private IMonitorValidationFacadeService validationService;

    @Autowired
    private IIamClient iamClient;

    @Override
    @RouterKey
    public ExistActiveProjectVO postExistActiveProject(String actionId, String tenantId, Map<String, String> eocMap) {
        LOGGER.info("检查是否有进行中项目入参actionId:{},tenantId:{},eocMap:{}", actionId, tenantId, JsonUtil.getJsonString(eocMap));
        /** 解析token判断tenantId是否一致 **/
        if (!iamClient.isTenantIdMatchByToken(tenantId)) {
            throw new ArgumentValidException(ErrorCodeEnum.TOKEN_NOT_MATCH_TENANT_ID);
        }
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(eocMap);
        boolean existActiveProject = validationService.existActiveProject(actionId, tenantId, eocDto);
        return new ExistActiveProjectVO(existActiveProject);
    }

    @Override
    @RouterKey
    @Deprecated
    public ExistActiveProjectVO postExistActiveProject(String actionId, String tenantId, Map<String, String> eocMap, String secure) {
        LOGGER.info("检查是否有进行中项目入参actionId:{},tenantId:{},eocMap:{}", actionId, tenantId, JsonUtil.getJsonString(eocMap));
        /** 解析token判断tenantId是否一致 **/
        if (!iamClient.isTenantIdMatchByToken(tenantId)) {
            throw new ArgumentValidException(ErrorCodeEnum.TOKEN_NOT_MATCH_TENANT_ID);
        }
        /** 验证当前加密串是否正确*/
        boolean checkSecure = SecurityUtil.verifySecure(secure, FieldConstant.SECURE_TYPE_REDISOPS);
        if (!checkSecure) {
            throw new ArgumentValidException(ErrorCodeEnum.SECURE_ERR);
        }
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(eocMap);
        boolean existActiveProject = validationService.existActiveProject(actionId, tenantId, eocDto);
        return new ExistActiveProjectVO(existActiveProject);
    }
}
