package com.digiwin.athena.cdme.provider;

import com.digiwin.athena.cdme.core.aop.RouterKey;
import com.digiwin.athena.cdme.mq.producer.MessageProducer;
import com.digiwin.athena.cdme.pojo.request.RouterRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @author yang.xiao
 * @version V1.0
 * @Description
 * @date 2023/11/13 13:49
 * @Copyright 鼎捷软件股份有限公司
 */
@Service("cdmeRouterService")
public class RouterService implements IRouterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterService.class);

    private final MessageProducer producer;

    public RouterService(MessageProducer producer) {
        this.producer = producer;
    }

    @Override
    @RouterKey
    public void deliver(RouterRequest routerReq) {
        LOGGER.info("路由转发消息:[{}]", routerReq.getQueueMsg());
        producer.sendMessage(routerReq.getQueueMsg());
    }
}