package com.digiwin.athena.cdme.repository.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.SnowIdUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;

import java.time.LocalDateTime;

/**
 * @description: 侦测执行记录
 * @author: renwm
 * @date: 2020/5/8 16:36
 */
@TableName("sd_monitor_record")
public class MonitorRecordModel {
    /** 主键ID */
    @TableId(type = IdType.AUTO)
    private Long kid;
    /** 请求ID */
    private Long callKid;
    /** 规则ID */
    private String ruleId;
    /** 租户ID */
    private String tenantId;
    /** 执行服务ID */
    private String actionId;
    /** 状态 */
    private Integer status;
    /** EOC运营单元 */
    private String eocId;
    /** esp 返回的侦测结果 */
    private String monitorResult;
    /** 创建时间 */
    private LocalDateTime createTime;
    /** 更新时间 */
    private LocalDateTime updateTime;
    /** 执行引擎返回结果 */
    private String actionResult;
    /** 侦测状态 */
    private String monitorStatus;
    /** 流程状态 */
    private String actionStatus;
    /** 调用类型:排程自动调用或者手动触发调用执行侦测任务 */
    private String postType;
    /** 记录发起该侦测流程时的侦测触发时间（对应trigger表中last_monitor_time）*/
    private LocalDateTime monitorTime;
    /** eoc公司ID */
    private String eocCompanyId;
    /** eoc工厂ID */
    private String eocSiteId;
    /** eoc区域ID */
    private String eocRegionId;

    public MonitorRecordModel() {
    }

    public MonitorRecordModel(String postType, MonitorRuleModel tempModel, EocDto eocDto, LocalDateTime monitorTime) {
        this.callKid = SnowIdUtil.uniqueLong();
        this.ruleId = tempModel.getRuleId();
        this.tenantId = tempModel.getTenantId();
        this.actionId = tempModel.getActionId();
        this.status = ResultEnum.ESP_EXECUTE_FAILED.getStatus();
        this.createTime = LocalTimeUtil.now();
        this.eocId = JsonUtil.getJsonString(eocDto);
        this.eocCompanyId = StringUtil.emptyToNull(eocDto.getEocCompanyId());
        this.eocSiteId = StringUtil.emptyToNull(eocDto.getEocSiteId());
        this.eocRegionId = StringUtil.emptyToNull(eocDto.getEocRegionId());
        this.postType = postType;
        this.monitorTime = monitorTime;
    }

    public Long getKid() {
        return kid;
    }

    public void setKid(Long kid) {
        this.kid = kid;
    }

    public Long getCallKid() {
        return callKid;
    }

    public void setCallKid(Long callKid) {
        this.callKid = callKid;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getEocId() {
        return eocId;
    }

    public void setEocId(String eocId) {
        this.eocId = eocId;
    }

    public String getMonitorResult() {
        return monitorResult;
    }

    public void setMonitorResult(String monitorResult) {
        this.monitorResult = monitorResult;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getActionResult() {
        return actionResult;
    }

    public void setActionResult(String actionResult) {
        this.actionResult = actionResult;
    }

    public String getMonitorStatus() {
        return monitorStatus;
    }

    public void setMonitorStatus(String monitorStatus) {
        this.monitorStatus = monitorStatus;
    }

    public String getActionStatus() {
        return actionStatus;
    }

    public void setActionStatus(String actionStatus) {
        this.actionStatus = actionStatus;
    }

    public String getPostType() {
        return postType;
    }

    public void setPostType(String postType) {
        this.postType = postType;
    }

    public LocalDateTime getMonitorTime() {
        return monitorTime;
    }

    public void setMonitorTime(LocalDateTime monitorTime) {
        this.monitorTime = monitorTime;
    }

    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public String getEocRegionId() {
        return eocRegionId;
    }

    public void setEocRegionId(String eocRegionId) {
        this.eocRegionId = eocRegionId;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
