package com.digiwin.athena.cdme.service.client;

import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;

import java.util.List;

/**
 * @description:
 * @author: dongwh
 * @date: 2021/10/19 15:46
 */
public interface IScheduleClient {

    /**
     * 创建排程
     * @param ruleDto
     * @param scheduleStatus 排程状态：Y/N
     * @return
     */
    ResultDto createSchedule(List<MonitorRuleDto> ruleDto, String scheduleStatus);
    /**
     * 修改排程
     * @param ruleDto
     * @param scheduleStatus 排程状态：Y/N
     * @return
     */
    ResultDto editSchedule(MonitorRuleDto ruleDto, String scheduleStatus);

    /**
     * 停止排程
     * @param triggerId
     * @param tenantId
     * @return
     */
    ResultDto stopSchedule(String triggerId, String tenantId);

    /**
     * 开启排程
     * @param triggerId
     * @param tenantId
     * @return
     */
    ResultDto startSchedule(String triggerId, String tenantId);

    /**
     * 删除排程
     * @param triggerId
     * @param tenantId
     * @return
     */
    ResultDto deleteSchedule(String triggerId, String tenantId);

    /**
     * 根据指定的租户ID与triggerId获取对应排程实例状态
     *
     * @param triggerId
     * @param tenantId
     * @param token
     * @return
     */
    ResultDto<String> getScheduleStatus(String triggerId, String tenantId, String token);

    /**
     * 排程是否为禁用状态
     */
    ResultDto<Boolean> isScheduleDisabled(String triggerId, String tenantId, String token);
}
