package com.digiwin.athena.cdme.service.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;

/**
 * @description: 服务编排客户端 NOTE 临时功能-1764
 * @author: liunansheng
 * @date: 2021/10/22 13:58
 */
public interface IScwokerClient {

    /**
     * 查询是否存在进行中项目
     *
     * @param serviceComposerId
     * @param tenantId
     * @param eocMap
     * @return
     */
    boolean existActiveProject(String serviceComposerId, String tenantId, EocDto eocMap);

    /**
     * 发起服务编排
     * @param serviceComposerId
     * @param tenantId
     * @param eocDto
     * @param monitorData
     * @return
     */
    ResultDto<JSON> processService(String serviceComposerId, String tenantId, EocDto eocDto,
        JSONArray monitorData);
}
