package com.digiwin.athena.cdme.service.facade.detection;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.cdme.pojo.bo.DetectionAndExecuteContextBO;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/3 10:15
 */
public interface IDetectionEventService {
    /**
     * 开始侦测事件
     * @param ruleModel
     * @return
     */
    void startDetection(MonitorRuleModel ruleModel);

    /**
     * 侦测前失败事件
     * @param ruleModel
     * @param exception
     * @return
     */
    void preHandleException(MonitorRuleModel ruleModel, DWRuntimeException exception);

    /**
     * 侦测结束事件
     * @param postType
     * @param ruleModel
     * @param contexts
     * @return
     */
    void endDetection(String postType, MonitorRuleModel ruleModel,
        List<DetectionAndExecuteContextBO> contexts);
}
