package com.digiwin.athena.cdme.service.facade.detection.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.pojo.dto.DetectionRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/3 17:52
 */
@Service("cdmeDetectionFacdeProxy")
public class DetectionFacdeProxy {

    private final Map<String, IProcessDetectionService> detectionServiceMap;

    public DetectionFacdeProxy(Map<String, IProcessDetectionService> detectionServiceMap) {
        this.detectionServiceMap = detectionServiceMap;
    }

    public ResultDto<JSONArray> processDetection(Map<String, JSONObject> allParam, DetectionRequestDto requestDto) {
        MonitorRuleModel ruleModel = requestDto.getRuleModel();
        IProcessDetectionService detectionService = detectionServiceMap.get(ruleModel.getCategory());
        if (null == detectionService) {
            throw new BusinessException(ErrorCodeEnum.UNKONW_CATEGORY);
        }
        return detectionService.processDetection(allParam, requestDto);
    }
}
