package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.DeduplicateDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorDupModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.data.IFinishDetectionService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorDupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.stream.Collectors;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/4 13:43
 */
@Service("cdmeFinishDetectionService")
public class FinishDetectionService implements IFinishDetectionService {

    private static Logger LOGGER = LoggerFactory.getLogger(FinishDetectionService.class);

    private final ICacheService cacheService;

    private final IMonitorDupService monitorDupService;

    public FinishDetectionService(ICacheService cacheService, IMonitorDupService monitorDupService) {
        this.cacheService = cacheService;
        this.monitorDupService = monitorDupService;
    }


    @Override
    public ResultDto<DeduplicateDto> deduplicate(JSONArray data, EocDto eoc, MonitorRuleModel ruleModel) {
        //数据为空或不需要去重
        if (CollectionUtil.isEmpty(data) || !MonitorHelper.isPollingIds(ruleModel.getMonitorRule())) {
            return ResultHelper.generateSuccessResult(new DeduplicateDto(data, null));
        }
        LOGGER.info("..... redis去重之前数据为:{}", data);
        String cacheKey = MonitorHelper.buildRedisKey(ruleModel, eoc);
        JSONArray intersection = new JSONArray();
        JSONArray cacheObject = getCacheObject(cacheKey, ruleModel, eoc);
        if (CollectionUtil.isNotEmpty(cacheObject)) {
            /** 取交集数据 */
            JSONArray finalCacheObject = cacheObject;
            intersection = data.stream().filter(finalCacheObject::contains).collect(Collectors.toCollection(JSONArray::new));
            /** 取去重后的数据 */
            data.removeAll(cacheObject);
        }
        LOGGER.info("..... redis去重之后数据为:{}", data);
        return ResultHelper.generateSuccessResult(new DeduplicateDto(data, intersection));
    }

    protected JSONArray getCacheObject(String cacheKey, MonitorRuleModel ruleModel, EocDto eocDto) {
        /** key值在redis中是否存在 */
        try {
            boolean hasKey = cacheService.hasKey(cacheKey);
            if (hasKey) {
                JSONArray cacheStr = cacheService.get(cacheKey);
                LOGGER.info("..... redis中缓存数据为:{},redisKey为:{}", cacheStr, cacheKey);
                return cacheStr;
            }
        } catch (Exception e) {
            LOGGER.error("去重时获取redis数据异常, 参数为:ruleModel:[{}] eocDto:[{}] redisKey[{}]", ruleModel, JsonUtil.getJsonString(eocDto), cacheKey);
            LOGGER.error("去重时获取redis数据异常信息", e);
        }

        /** 判断key值对应的value在DB中是否有存储记录*/
        MonitorDupModel monitorDup = monitorDupService.getByRuleIdAndTenantIdAndProdAndEocmap(ruleModel.getRuleId(), ruleModel.getTenantId(), ruleModel.getProductName(), eocDto);
        if (monitorDup == null) {
            return new JSONArray();
        }
        return JsonUtil.parseArray(monitorDup.getCacheValue());
    }
}
