package com.digiwin.athena.cdme.service.facade.detection.execution.impl;

import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ExecuteRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ProcessPageDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.data.IDupDataCacheFacadeService;
import com.digiwin.athena.cdme.service.facade.detection.execution.IFinishExecutionService;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/4 15:38
 */
@Service("cdmeFinishExecutionService")
public class FinishExecutionService implements IFinishExecutionService {

    private final IDupDataCacheFacadeService dupDataCacheFacadeService;

    public FinishExecutionService(IDupDataCacheFacadeService dupDataCacheFacadeService) {
        this.dupDataCacheFacadeService = dupDataCacheFacadeService;
    }

    @Override
    public ResultDto<Void> syncProcess(ExecuteRequestDto executeRequest, ProcessPageDto processPageDto) {
        MonitorRuleModel ruleModel = executeRequest.getRuleModel();
        if (!MonitorHelper.isPollingIds(ruleModel.getMonitorRule())) {
            return ResultHelper.generateSuccessResult(null);
        }
        EocDto eoc = executeRequest.getEocDto();
        String redisKey = MonitorHelper.buildRedisKey(ruleModel, eoc);
        dupDataCacheFacadeService.syncProcess(ruleModel, eoc, processPageDto.genSuccessChangeObjects(), executeRequest.getDupData(), redisKey, processPageDto.partFail());
        return ResultHelper.generateSuccessResult(null);
    }
}
