package com.digiwin.athena.cdme.service.facade.detection.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorIntervelLimitService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/2/13 11:13
 */
@Service("cdmeMonitorIntervelLimitService")
public class MonitorIntervelLimitService implements IMonitorIntervelLimitService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorIntervelLimitService.class);

    private final ICacheService cacheService;

    public MonitorIntervelLimitService(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public boolean canProcess(MonitorRuleModel ruleModel) {
        JSONObject rule = JsonUtil.getObject(ruleModel.getMonitorRule());
        Integer interval = rule.getInteger(FieldConstant.CHILL_INTERVAL);
        LOGGER.info("[侦测引擎获取时间间隔限制]:interval:[{}]", interval);
        if (null == interval || interval <= 0) {
            return true;
        }
        String key = MonitorHelper.buildIntervelLimitKey(ruleModel);
        Object v = cacheService.get(key);
        LOGGER.info("[侦测引擎获取时间间隔限制]:interval:[{}]", JsonUtil.getJsonString(v));
        LOGGER.info("[侦测引擎设置时间间隔限制成功:{},[{}]", key, JsonUtil.getJsonString(v));
        return null == v;
    }

    @Override
    public void setLimiter(MonitorRuleModel ruleModel) {
        JSONObject rule = JsonUtil.getObject(ruleModel.getMonitorRule());
        Integer interval = rule.getInteger(FieldConstant.CHILL_INTERVAL);
        LOGGER.info("[侦测引擎设置时间间隔限制]:interval:[{}]", interval);
        if (null == interval || interval <= 0) {
            return;
        }
        String key = MonitorHelper.buildIntervelLimitKey(ruleModel);
        cacheService.set(key, 1, interval);
        LOGGER.info("[侦测引擎设置时间间隔限制成功:{}", key);
    }
}
