package com.digiwin.athena.cdme.service.facade.rulesync;

import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;

import java.util.List;
import java.util.Objects;

/**
 * @description: 侦测规则同步抽象类
 * @author: dongwh
 * @date: 2021/10/20 14:27
 */
public abstract class AbstractCreateRuleService {

    protected final IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;

    protected final IThemeMapClient themeMapClient;

    public AbstractCreateRuleService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IThemeMapClient themeMapClient) {
        this.ruleTriggerOperatorFacadeService = ruleTriggerOperatorFacadeService;
        this.themeMapClient = themeMapClient;
    }

    /**
     * 新增侦测规则数据
     *
     * @param tenantId
     * @param eocDto
     * @param ruleId
     * @param enableStatus
     * @return
     */
    protected ResultDto<MonitorRuleDto> saveRule(String tenantId, EocDto eocDto, String ruleId, String enableStatus) {
        ResultDto verifyResult = verify(tenantId, eocDto, ruleId, enableStatus);
        if (MonitorHelper.isResultFail(verifyResult)) {
            return verifyResult;
        }

        MonitorRuleDto ruleDto = themeMapClient.getRuleInfo(tenantId, eocDto, ruleId);
        ruleTriggerOperatorFacadeService.saveCdcRule(ruleDto, eocDto);
        return ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage(), ruleDto);
    }

    private ResultDto verify(String tenantId, EocDto eocDto, String ruleId, String scheduleStatus) {
        MonitorCdcRuleDto monitorCdcRuleDto = ruleTriggerOperatorFacadeService.queryCdcRuleDetailByRuleIdAndTenantId(ruleId, tenantId, eocDto);
        if (!Objects.isNull(monitorCdcRuleDto.getRuleModel())) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.RULE_ALREADY_EXISTS);
        }
        return ResultHelper.generateResult(true, "");
    }
}
