package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorCdcTopicRouteMapper;
import com.digiwin.athena.cdme.repository.model.MonitorCdcTopicRouteModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorCdcTopicRouteService;
import org.springframework.stereotype.Service;

/**
 * @author yang.xiao
 * @version V1.0
 * @Description
 * @date 2023/10/23 11:12
 * @Copyright 鼎捷软件股份有限公司
 */
@Service("cdmeMonitorCdcTopicRouteService")
public class MonitorCdcTopicRouteService extends AbstractRepositorService<CdmeMonitorCdcTopicRouteMapper, MonitorCdcTopicRouteModel> implements IMonitorCdcTopicRouteService {

    public MonitorCdcTopicRouteService(CdmeMonitorCdcTopicRouteMapper mapper){super(mapper);};

    @Override
    public MonitorCdcTopicRouteModel getByTopicAndGroup(String topicName, String groupName) {
        LambdaQueryWrapper<MonitorCdcTopicRouteModel> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MonitorCdcTopicRouteModel::getTopicName, topicName);
        queryWrapper.eq(MonitorCdcTopicRouteModel::getConsumerGroup, groupName);
        queryWrapper.last("limit 1");
        return mapper.selectOne(queryWrapper);
    }
}