/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class CdmeRedisTemplateConfig {
    private static final String PREFIX = "cdme:";

    @Bean(value={"cdmeRedisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory, Environment environment) {
        return this.getRedisTemplate(redisConnectionFactory, environment, (RedisSerializer<String>)new StringRedisSerializer(), (RedisSerializer<String>)new PrefixRedisSerializer());
    }

    public RedisTemplate<String, Object> getRedisTemplate(RedisConnectionFactory redisConnectionFactory, Environment environment, RedisSerializer<String> redisSerializer, RedisSerializer<String> keySerializerRedisSerializer) {
        GenericJackson2JsonRedisSerializer serializer;
        String serializeNullString = environment.getProperty("dap.redis.serialize-null", "true");
        boolean serializeNull = Boolean.parseBoolean(serializeNullString);
        if (serializeNull) {
            serializer = new GenericJackson2JsonRedisSerializer();
        } else {
            ObjectMapper om = new ObjectMapper();
            om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
            serializer = new GenericJackson2JsonRedisSerializer(om);
        }
        RedisTemplate redis = new RedisTemplate();
        redis.setKeySerializer(keySerializerRedisSerializer);
        redis.setValueSerializer((RedisSerializer)serializer);
        redis.setHashKeySerializer(redisSerializer);
        redis.setHashValueSerializer((RedisSerializer)serializer);
        redis.setConnectionFactory(redisConnectionFactory);
        redis.afterPropertiesSet();
        return redis;
    }

    static class PrefixRedisSerializer
    extends StringRedisSerializer {
        PrefixRedisSerializer() {
        }

        public byte[] serialize(String s) {
            if (s == null) {
                return null;
            }
            String realKey = CdmeRedisTemplateConfig.PREFIX + s;
            return super.serialize(realKey);
        }

        public String deserialize(byte[] bytes) {
            String s;
            String string = s = bytes == null ? null : new String(bytes);
            assert (s != null);
            int index = s.indexOf(CdmeRedisTemplateConfig.PREFIX);
            if (index != -1) {
                return s.substring(CdmeRedisTemplateConfig.PREFIX.length());
            }
            return s;
        }
    }
}

