/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.config;

import com.digiwin.athena.cdme.core.util.StringUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CdmeRedissonConfig {
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private String port;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.database}")
    private int database;
    @Value(value="${spring.redis.timeout}")
    private int connectTimeout;
    @Value(value="${spring.redis.lettuce.pool.min-idle}")
    private int connectionMinIdleSize;
    @Value(value="${spring.redis.lettuce.pool.max-active}")
    private int connectionPoolMaxActive;

    @Bean(value={"cdmeRedissonClient"})
    public RedissonClient redissonClient() {
        Config config = new Config();
        ((SingleServerConfig)config.useSingleServer().setAddress("redis://" + this.host + ":" + this.port).setDatabase(this.database).setConnectTimeout(this.connectTimeout)).setConnectionMinimumIdleSize(this.connectionMinIdleSize).setConnectionPoolSize(this.connectionPoolMaxActive);
        if (StringUtil.isBlank(this.password)) {
            config.useSingleServer().setPassword(null);
        } else {
            config.useSingleServer().setPassword(this.password);
        }
        return Redisson.create((Config)config);
    }
}

