/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.Objects;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.enumerate.OpType;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import java.math.BigDecimal;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public final class FilterUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterUtil.class);

    public static boolean filterData(JSONObject data, String op, MonitorRuleCdcModel monitorRuleCdcModel) {
        if (FilterUtil.executeValidFilter(monitorRuleCdcModel)) {
            LOGGER.info("\u4fa6\u6d4b\uff1a{}->\u4fa6\u6d4b\u5f15\u64ceCDC\u6d88\u606f\u88ab\u5173\u95ed\u72b6\u6001\u8fc7\u6ee4:{}", (Object)monitorRuleCdcModel.getRuleId(), (Object)data);
            return true;
        }
        if (FilterUtil.executeStartTimeFilter(monitorRuleCdcModel)) {
            LOGGER.info("\u4fa6\u6d4b\uff1a{}->\u4fa6\u6d4b\u5f15\u64ceCDC\u6d88\u606f\u88ab\u5f00\u59cb\u65f6\u95f4\u8fc7\u6ee4:{}", (Object)monitorRuleCdcModel.getRuleId(), (Object)data);
            return true;
        }
        if ("u".equals(op) && FilterUtil.executeChangeFieldsFilter(data, monitorRuleCdcModel)) {
            LOGGER.info("\u4fa6\u6d4b\u5f15\u64ceCDC\u6d88\u606f\u88ab\u53d8\u5316\u5b57\u6bb5\u8fc7\u6ee4:{}", (Object)monitorRuleCdcModel.getRuleId(), (Object)data);
            return true;
        }
        if ("MQTT".equals(monitorRuleCdcModel.getCategory())) {
            if (StringUtil.isNotBlank(monitorRuleCdcModel.getFilterCondition()) && FilterUtil.executeFilterConditionsFilter(data, monitorRuleCdcModel)) {
                LOGGER.info("\u4fa6\u6d4b\uff1a{}->\u4fa6\u6d4b\u5f15\u64ceMQTT\u6d88\u606f\u88ab\u8fc7\u6ee4\u7cfb\u7edf\u7ea7\u6761\u4ef6\u8fc7\u6ee4:{}", (Object)monitorRuleCdcModel.getRuleId(), (Object)data);
                return true;
            }
            if (FilterUtil.executeConvFilterConditionsFilter(data, monitorRuleCdcModel)) {
                LOGGER.info("\u4fa6\u6d4b\uff1a{}->\u4fa6\u6d4b\u5f15\u64ceMQTT\u6d88\u606f\u88ab\u8fc7\u6ee4\u6761\u4ef6\u8fc7\u6ee4:{}", (Object)monitorRuleCdcModel.getRuleId(), (Object)data);
                return true;
            }
        } else if (FilterUtil.executeFilterConditionsFilter(data, monitorRuleCdcModel)) {
            LOGGER.info("\u4fa6\u6d4b\uff1a{}->\u4fa6\u6d4b\u5f15\u64ceCDC\u6d88\u606f\u88ab\u8fc7\u6ee4\u6761\u4ef6\u8fc7\u6ee4:{}", (Object)monitorRuleCdcModel.getRuleId(), (Object)data);
            return true;
        }
        return false;
    }

    private static boolean executeStartTimeFilter(MonitorRuleCdcModel monitorRuleCdcModel) {
        return !LocalTimeUtil.isBefore(LocalTimeUtil.getDateTime(monitorRuleCdcModel.getStartTime()), LocalTimeUtil.getCurrentDateTime());
    }

    private static boolean executeValidFilter(MonitorRuleCdcModel monitorRuleCdcModel) {
        return !"ENABLED".equals(monitorRuleCdcModel.getValid());
    }

    private static boolean executeFilterConditionsFilter(JSONObject data, MonitorRuleCdcModel monitorRuleCdcModel) {
        JSONArray filterConditions = JsonUtil.parseArray(monitorRuleCdcModel.getFilterCondition());
        for (Object filterCondition : filterConditions) {
            String afterValue;
            String left = ((JSONObject)filterCondition).getString("left");
            String right = ((JSONObject)filterCondition).getString("right");
            String op = ((JSONObject)filterCondition).getString("op");
            String string = afterValue = ObjectUtils.isEmpty((Object)data.getJSONObject("after")) ? data.getJSONObject("before").getString(left) : data.getJSONObject("after").getString(left);
            if (OpType.EQUAL.toString().equals(op) && !afterValue.equals(right)) {
                return true;
            }
            if (OpType.NOT_EQUAL.toString().equals(op) && afterValue.equals(right)) {
                return true;
            }
            if (OpType.IS_NULL.toString().equals(op) && StringUtil.isNotBlank(afterValue)) {
                return true;
            }
            if (OpType.IS_NOT_NULL.toString().equals(op) && StringUtil.isEmpty(afterValue)) {
                return true;
            }
            if (OpType.GREATER_EQUAL.toString().equals(op)) {
                BigDecimal afterBigDecimal = new BigDecimal(afterValue);
                BigDecimal rightBigDecimal = new BigDecimal(right);
                return afterBigDecimal.compareTo(rightBigDecimal) < 0 || !afterValue.equals(right);
            }
            if (OpType.LESS_EQUAL.toString().equals(op)) {
                BigDecimal afterBigDecimal = new BigDecimal(afterValue);
                BigDecimal rightBigDecimal = new BigDecimal(right);
                return afterBigDecimal.compareTo(rightBigDecimal) > -1;
            }
            if (OpType.GREATER_THAN.toString().equals(op)) {
                BigDecimal afterBigDecimal = new BigDecimal(afterValue);
                BigDecimal rightBigDecimal = new BigDecimal(right);
                return afterBigDecimal.compareTo(rightBigDecimal) < 0;
            }
            if (!OpType.LESS_THAN.toString().equals(op)) continue;
            BigDecimal afterBigDecimal = new BigDecimal(afterValue);
            BigDecimal rightBigDecimal = new BigDecimal(right);
            return afterBigDecimal.compareTo(rightBigDecimal) > 0;
        }
        return false;
    }

    private static boolean executeChangeFieldsFilter(JSONObject data, MonitorRuleCdcModel monitorRuleCdcModel) {
        JSONArray changeFields = JsonUtil.parseArray(monitorRuleCdcModel.getChangeFields());
        for (Object changeField : changeFields) {
            String afterValue;
            String field = ((JSONObject)changeField).getString("name");
            String beforeValue = data.getJSONObject("before").getString(field);
            if (!beforeValue.equals(afterValue = data.getJSONObject("after").getString(field))) continue;
            return true;
        }
        return false;
    }

    public static boolean executeAvailabilityFilter(MonitorRuleCdcModel monitorRuleCdcModel) {
        return Objects.isNull((Object)monitorRuleCdcModel);
    }

    private static boolean executeConvFilterConditionsFilter(JSONObject data, MonitorRuleCdcModel monitorRuleCdcModel) {
        if (StringUtils.isEmpty((CharSequence)monitorRuleCdcModel.getConversionFilterCondition())) {
            return false;
        }
        JSONArray filterConditions = JsonUtil.parseArray(monitorRuleCdcModel.getConversionFilterCondition());
        for (int i = 0; i < filterConditions.size(); ++i) {
            JSONObject filterCon = filterConditions.getJSONObject(i);
            JSONArray items = filterCon.getJSONArray("items");
            boolean conGroupFlag = true;
            for (int j = 0; j < items.size(); ++j) {
                String afterValue;
                String op;
                String right;
                JSONObject item = items.getJSONObject(j);
                String left = item.getString("left");
                if (!FilterUtil.valideExp(left, right = item.getString("right"), op = item.getString("op"), afterValue = data.getJSONObject("after").getString(left))) continue;
                conGroupFlag = false;
                break;
            }
            if (!conGroupFlag) continue;
            return false;
        }
        return true;
    }

    private static boolean valideExp(String left, String right, String op, String afterValue) {
        if (OpType.EQUAL.toString().equals(op) && !afterValue.equals(right)) {
            return true;
        }
        if (OpType.NOT_EQUAL.toString().equals(op) && afterValue.equals(right)) {
            return true;
        }
        if (OpType.IS_NULL.toString().equals(op) && StringUtil.isNotBlank(afterValue)) {
            return true;
        }
        if (OpType.IS_NOT_NULL.toString().equals(op) && StringUtil.isEmpty(afterValue)) {
            return true;
        }
        if (OpType.GREATER_EQUAL.toString().equals(op)) {
            BigDecimal afterBigDecimal = new BigDecimal(afterValue);
            BigDecimal rightBigDecimal = new BigDecimal(right);
            return afterBigDecimal.compareTo(rightBigDecimal) == -1 || !afterValue.equals(right);
        }
        if (OpType.LESS_EQUAL.toString().equals(op)) {
            BigDecimal afterBigDecimal = new BigDecimal(afterValue);
            BigDecimal rightBigDecimal = new BigDecimal(right);
            return afterBigDecimal.compareTo(rightBigDecimal) != -1;
        }
        if (OpType.GREATER_THAN.toString().equals(op)) {
            BigDecimal afterBigDecimal = new BigDecimal(afterValue);
            BigDecimal rightBigDecimal = new BigDecimal(right);
            return afterBigDecimal.compareTo(rightBigDecimal) == -1;
        }
        if (OpType.LESS_THAN.toString().equals(op)) {
            BigDecimal afterBigDecimal = new BigDecimal(afterValue);
            BigDecimal rightBigDecimal = new BigDecimal(right);
            return afterBigDecimal.compareTo(rightBigDecimal) == 1;
        }
        if (OpType.LEFT_LIKE.toString().equals(op) && !afterValue.startsWith(right)) {
            return true;
        }
        if (OpType.IN.toString().equals(op) || OpType.NOT_IN.toString().equals(op)) {
            JSONArray jsonArray = JSON.parseArray((String)right);
            Optional<Object> first = jsonArray.stream().filter(s -> s.equals(afterValue)).findFirst();
            if (first.isPresent()) {
                if (OpType.IN.toString().equals(op)) {
                    return false;
                }
                if (OpType.NOT_IN.toString().equals(op)) {
                    return true;
                }
            } else if (OpType.IN.toString().equals(op)) {
                return true;
            }
        }
        return false;
    }
}

