/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.mq.consumer.rule;

import com.digiwin.athena.cdme.core.exception.Retryable;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.service.client.impl.ThemeMapClient;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Service;

@Service(value="cdmeRuleSyncCallBack")
public class RuleSyncCallBack {
    private final ThemeMapClient themeMapClient;

    public RuleSyncCallBack(ThemeMapClient themeMapClient) {
        this.themeMapClient = themeMapClient;
    }

    public void successCallBack(String transactionId, String ruleId) {
        if (StringUtil.isNotBlank(transactionId)) {
            this.themeMapClient.syncRuleCallBack(transactionId, ruleId, true, null);
        }
    }

    public void failCallBack(String transactionId, String ruleId, Throwable e, Message message) {
        boolean requeue;
        boolean isRetry = e instanceof Retryable;
        boolean bl = requeue = message.getMessageProperties() != null && BooleanUtils.isFalse((Boolean)message.getMessageProperties().getRedelivered());
        if (!(isRetry && requeue || !StringUtil.isNotBlank(transactionId))) {
            String msg = StringUtil.isNotBlank(e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u5f02\u5e38";
            this.themeMapClient.syncRuleCallBack(transactionId, ruleId, false, msg);
        }
    }
}

