/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.aop.ExceptionRetry;
import com.digiwin.athena.cdme.core.aop.RouterKey;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.MonitorOpsEnum;
import com.digiwin.athena.cdme.core.exception.ArgumentValidException;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.SecurityUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.RuleOpsDto;
import com.digiwin.athena.cdme.pojo.vo.MonitorOpsDetailVo;
import com.digiwin.athena.cdme.pojo.vo.MonitorOpsRuleVo;
import com.digiwin.athena.cdme.pojo.vo.SyncRuleInfoVo;
import com.digiwin.athena.cdme.provider.IMonitorOpsService;
import com.digiwin.athena.cdme.provider.converter.EocDtoConverter;
import com.digiwin.athena.cdme.provider.converter.MonitorOpsVoConverter;
import com.digiwin.athena.cdme.provider.converter.RuleVoConverter;
import com.digiwin.athena.cdme.repository.model.MonitorOptRecordModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.facade.auth.ITokenFacadeService;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorOptRecordService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorTriggerService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorOpsService")
public class MonitorOpsService
implements IMonitorOpsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorOpsService.class);
    @Autowired
    private IMonitorRuleService ruleService;
    @Autowired
    private IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;
    @Autowired
    private IMonitorTriggerService triggerService;
    @Autowired
    private IMonitorOptRecordService optRecordService;
    @Autowired
    protected IScheduleClient scheduleClient;
    @Autowired
    private IIamClient iamClient;
    @Autowired
    private ITokenFacadeService tokenFacadeService;

    @Override
    @RouterKey
    @ExceptionRetry(times=3, waitTime=300L)
    public JSONArray postMonitorInfo(String ruleId, String tenantId, Map<String, String> eocMap, String secure) {
        LOGGER.info("\u64cd\u4f5cpostMonitorInfo\u7684\u5165\u53c2:ruleId:{},tenantId:{},eocMap:{}", new Object[]{ruleId, tenantId, eocMap});
        if (StringUtil.isBlank(tenantId)) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        boolean isTestTenant = this.iamClient.isTest(tenantId);
        if (!isTestTenant && !SecurityUtil.verifySecure(secure, "MonitorOpsService")) {
            throw new ArgumentValidException(ErrorCodeEnum.SECURE_ERR);
        }
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(eocMap);
        if (StringUtil.isBlank(ruleId)) {
            List<MonitorRuleModel> rules = this.ruleService.listByTenantIdAndEoc(tenantId, eocDto);
            if (CollectionUtil.isEmpty(rules)) {
                return new JSONArray();
            }
            return JsonUtil.getJsonArray(rules.stream().map(one -> MonitorOpsVoConverter.convertModelToOpsSummaryVo(one)).collect(Collectors.toList()));
        }
        List<RuleOpsDto> details = this.ruleTriggerOperatorFacadeService.listRuleDetailByRuleIdAndEoc(ruleId, tenantId, eocDto);
        if (CollectionUtil.isEmpty(details)) {
            return new JSONArray();
        }
        List voList = details.stream().map(dto -> {
            MonitorOpsDetailVo vo = MonitorOpsVoConverter.convertOpsDetailVoByDto(dto);
            if (null != dto.getTriggerModel()) {
                String token = this.tokenFacadeService.getTenantToken(tenantId);
                ResultDto resultSchedule = this.isScheduleDisabled(dto.getTriggerModel().getId(), tenantId, token);
                String scheduleInstanceStatus = MonitorOpsEnum.SCHEDULE_ISENABLE_N.getDesc();
                if (MonitorHelper.isResultFail(resultSchedule)) {
                    scheduleInstanceStatus = "SCHEDULE_IS_ENABLED".equals(resultSchedule.getData()) ? MonitorOpsEnum.SCHEDULE_ISENABLE_Y.getDesc() : resultSchedule.getMessage();
                }
                vo.setScheduleInstanceStatus(scheduleInstanceStatus);
            }
            return vo;
        }).collect(Collectors.toList());
        return JsonUtil.getJsonArray(voList);
    }

    @Override
    @RouterKey
    @Deprecated
    public String postBacktrackDate(String ruleId, String tenantId, Map<String, String> eocMap, String backtrackDate) {
        return this.notice();
    }

    @Override
    @RouterKey
    @Deprecated
    public String postBacktrackDate(String ruleId, String tenantId, Map<String, String> eocMap, String backtrackDate, String secure) {
        return this.notice();
    }

    @Deprecated
    private String notice() {
        return "\u5f53\u524d\u63a5\u53e3\u5df2\u5e9f\u5f03\uff0c\u8bf7\u4f7f\u7528\u89c4\u5219\u540c\u6b65\u63a5\u53e3\uff1a/restful/standard/MonitorEngine/rule/sync(changeType\u4e3aENABLED)\uff1b\n\u8be6\u60c5\u53ef\u53c2\u8003doclever\u6587\u6863\uff1ahttp://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#5eb275575f9aae000c969cac";
    }

    private ResultDto isScheduleDisabled(String triggerId, String tenantId, String token) {
        ResultDto<String> statusResult = this.scheduleClient.getScheduleStatus(triggerId, tenantId, token);
        if (MonitorHelper.isResultFail(statusResult)) {
            return statusResult;
        }
        if (!"N".equals(statusResult.getData())) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.SCHEDULE_IS_ENABLED, new Object[0]);
        }
        return ResultHelper.generateResult(true, "");
    }

    @Override
    @RouterKey
    @ExceptionRetry(times=3, waitTime=300L)
    public String getTestUserToken(String tenantId) {
        LOGGER.info("\u6839\u636e\u6d4b\u8bd5\u79df\u6237id\u83b7\u53d6\u79df\u6237token\u5165\u53c2:tenantId:{},\u65f6\u95f4:{}", (Object)tenantId, (Object)LocalTimeUtil.getCurrentDateTime());
        if (StringUtil.isBlank(tenantId)) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        String token = this.tokenFacadeService.getTenantToken(tenantId);
        DWServiceContext.getContext().setToken(token);
        boolean isTestTenant = this.iamClient.isTest(tenantId);
        if (!isTestTenant) {
            throw new BusinessException(ErrorCodeEnum.NOT_TEST_TENANT);
        }
        return token;
    }

    @Override
    @RouterKey
    public String getSecureUserToken(String tenantId, String secure) {
        LOGGER.info("\u6839\u636esecure\u53ca\u79df\u6237id\u83b7\u53d6\u79df\u6237token\u5165\u53c2:tenantId:{},\u65f6\u95f4:{}", (Object)tenantId, (Object)LocalTimeUtil.getCurrentDateTime());
        if (StringUtil.isBlank(tenantId) || StringUtil.isBlank(secure)) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        boolean checkSecure = SecurityUtil.verifySecure(secure, "RedisOperationService");
        if (!checkSecure) {
            throw new ArgumentValidException(ErrorCodeEnum.SECURE_ERR);
        }
        return this.tokenFacadeService.getTenantToken(tenantId);
    }

    @Override
    @RouterKey
    @ExceptionRetry(times=3, waitTime=300L)
    public String postSetPageSize(String ruleId, String tenantId, Map<String, String> eocMap, Integer pageSize) {
        boolean paramValid;
        LOGGER.info("\u8bbe\u7f6e\u6d4b\u8bd5\u79df\u6237\u5206\u9875\u4e0b\u53d1\u6267\u884c\u7684\u4fa6\u6d4b\u6570\u91cf\u5165\u53c2:ruleId:{},tenantId:{},eocMap:{},pageSize:{}, \u65f6\u95f4:{}", new Object[]{ruleId, tenantId, eocMap, pageSize, LocalTimeUtil.getCurrentDateTime()});
        boolean bl = paramValid = StringUtil.isBlank(ruleId) || StringUtil.isBlank(tenantId) || pageSize <= 0;
        if (paramValid) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        boolean isTestTenant = this.iamClient.isTest(tenantId);
        if (!isTestTenant) {
            throw new BusinessException(ErrorCodeEnum.NOT_TEST_TENANT);
        }
        return this.setPageSize(ruleId, tenantId, eocMap, pageSize);
    }

    @Override
    @RouterKey
    public String postSetPageSize(String ruleId, String tenantId, Map<String, String> eocMap, Integer pageSize, String secure) {
        boolean paramValid;
        LOGGER.info("\u8bbe\u7f6e\u5206\u9875\u4e0b\u53d1\u6267\u884c\u7684\u4fa6\u6d4b\u6570\u91cf\u5165\u53c2:ruleId:{},tenantId:{},eocMap:{},pageSize:{}, \u65f6\u95f4:{}", new Object[]{ruleId, tenantId, eocMap, pageSize, LocalTimeUtil.getCurrentDateTime()});
        boolean bl = paramValid = StringUtil.isBlank(ruleId) || StringUtil.isBlank(tenantId) || pageSize <= 0;
        if (paramValid) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        boolean checkSecure = SecurityUtil.verifySecure(secure, "MonitorOpsService");
        if (!checkSecure) {
            throw new ArgumentValidException(ErrorCodeEnum.SECURE_ERR);
        }
        return this.setPageSize(ruleId, tenantId, eocMap, pageSize);
    }

    private String setPageSize(String ruleId, String tenantId, Map<String, String> eocMap, Integer pageSize) {
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(eocMap);
        boolean isSuccess = this.ruleService.editPageSizeByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto, pageSize);
        this.optRecordService.save(new MonitorOptRecordModel(tenantId, ruleId, pageSize, eocDto, isSuccess));
        return isSuccess ? "SUCCESS" : ResultHelper.generateFailResult(ErrorCodeEnum.RULE_NOT_EXISTS, new Object[0]).getMessage();
    }

    @Override
    @RouterKey
    public Integer postGetPageSize(String ruleId, String tenantId, Map<String, String> eocMap) {
        LOGGER.info("\u83b7\u53d6\u5206\u9875\u4e0b\u53d1\u6267\u884c\u6570\u636e\u91cf\u5165\u53c2:ruleId:{},tenantId:{},eocMap:{}, \u65f6\u95f4:{}", new Object[]{ruleId, tenantId, eocMap, LocalTimeUtil.getCurrentDateTime()});
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(eocMap);
        MonitorRuleModel ruleModel = this.ruleService.getByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto);
        if (null == ruleModel) {
            throw new BusinessException(ErrorCodeEnum.RULE_NOT_EXISTS);
        }
        return ruleModel.getPageSize();
    }

    @Override
    @RouterKey
    @ExceptionRetry(times=3, waitTime=300L)
    public SyncRuleInfoVo postGetMonitorRule(String ruleId, String tenantId, Map<String, String> eocMap) {
        boolean paramValid;
        LOGGER.info("\u68c0\u67e5\u6d4b\u8bd5\u79df\u6237\u540c\u6b65\u7ed3\u679c\u662f\u5426\u6210\u529f\u5165\u53c2:ruleId:{},tenantId:{},eocMap:{}, \u65f6\u95f4:{}", new Object[]{ruleId, tenantId, eocMap, LocalTimeUtil.getCurrentDateTime()});
        boolean bl = paramValid = StringUtil.isBlank(ruleId) || StringUtil.isBlank(tenantId);
        if (paramValid) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        boolean isTestTenant = this.iamClient.isTest(tenantId);
        if (!isTestTenant) {
            throw new ArgumentValidException(ErrorCodeEnum.NOT_TEST_TENANT);
        }
        return this.getMonitorRule(ruleId, tenantId, eocMap);
    }

    @Override
    @RouterKey
    public SyncRuleInfoVo postGetMonitorRule(String ruleId, String tenantId, Map<String, String> eocMap, String secure) {
        boolean paramValid;
        LOGGER.info("\u68c0\u67e5\u540c\u6b65\u7ed3\u679c\u662f\u5426\u6210\u529f\u5165\u53c2:ruleId:{},tenantId:{},eocMap:{}, \u65f6\u95f4:{}", new Object[]{ruleId, tenantId, eocMap, LocalTimeUtil.getCurrentDateTime()});
        boolean bl = paramValid = StringUtil.isBlank(ruleId) || StringUtil.isBlank(tenantId) || StringUtil.isBlank(secure);
        if (paramValid) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        boolean checkSecure = SecurityUtil.verifySecure(secure, "MonitorOpsService");
        if (!checkSecure) {
            throw new ArgumentValidException(ErrorCodeEnum.SECURE_ERR);
        }
        return this.getMonitorRule(ruleId, tenantId, eocMap);
    }

    private SyncRuleInfoVo getMonitorRule(String ruleId, String tenantId, Map<String, String> eocMap) {
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(eocMap);
        MonitorRuleModel monitorRule = this.ruleService.getByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto);
        if (null == monitorRule) {
            LOGGER.error("\u5165\u53c2ruleId:{},tenantId:{},eocMap:{}\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4fa6\u6d4b\u89c4\u5219\uff0c\u8bf7\u67e5\u770b\uff01", new Object[]{ruleId, tenantId, eocMap});
            return null;
        }
        MonitorOpsRuleVo monitorOpsRuleVo = RuleVoConverter.convertModelToVo(monitorRule);
        if ("cdmeREPORT".equals(monitorRule.getCategory())) {
            return new SyncRuleInfoVo((JSON)new JSONObject(), monitorOpsRuleVo, false);
        }
        MonitorTriggerModel monitorTrigger = this.triggerService.getByTriggerId(monitorOpsRuleVo.getTriggerId());
        JSON standardPollingRule = JsonUtil.parse(monitorTrigger.getTriggerParam());
        String token = this.tokenFacadeService.getTenantToken(tenantId);
        ResultDto resultSchedule = this.isScheduleDisabled(monitorTrigger.getId(), tenantId, token);
        boolean scheduleInstanceStatus = false;
        if (MonitorHelper.isResultFail(resultSchedule)) {
            scheduleInstanceStatus = "SCHEDULE_IS_ENABLED".equals(resultSchedule.getData());
        }
        return new SyncRuleInfoVo(standardPollingRule, monitorOpsRuleVo, scheduleInstanceStatus);
    }
}

