/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.provider;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.aop.RouterKey;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.ArgumentValidException;
import com.digiwin.athena.cdme.core.util.SecurityUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.vo.ExistActiveProjectVO;
import com.digiwin.athena.cdme.provider.IMonitorValidationService;
import com.digiwin.athena.cdme.provider.converter.EocDtoConverter;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.athena.cdme.service.facade.ops.IMonitorValidationFacadeService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorValidationService")
public class MonitorValidationService
implements IMonitorValidationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorValidationService.class);
    @Autowired
    private IMonitorValidationFacadeService validationService;
    @Autowired
    private IIamClient iamClient;

    @Override
    @RouterKey
    public ExistActiveProjectVO postExistActiveProject(String actionId, String tenantId, Map<String, String> eocMap) {
        LOGGER.info("\u68c0\u67e5\u662f\u5426\u6709\u8fdb\u884c\u4e2d\u9879\u76ee\u5165\u53c2actionId:{},tenantId:{},eocMap:{}", new Object[]{actionId, tenantId, JsonUtil.getJsonString(eocMap)});
        if (!this.iamClient.isTenantIdMatchByToken(tenantId)) {
            throw new ArgumentValidException(ErrorCodeEnum.TOKEN_NOT_MATCH_TENANT_ID);
        }
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(eocMap);
        boolean existActiveProject = this.validationService.existActiveProject(actionId, tenantId, eocDto);
        return new ExistActiveProjectVO(existActiveProject);
    }

    @Override
    @RouterKey
    @Deprecated
    public ExistActiveProjectVO postExistActiveProject(String actionId, String tenantId, Map<String, String> eocMap, String secure) {
        LOGGER.info("\u68c0\u67e5\u662f\u5426\u6709\u8fdb\u884c\u4e2d\u9879\u76ee\u5165\u53c2actionId:{},tenantId:{},eocMap:{}", new Object[]{actionId, tenantId, JsonUtil.getJsonString(eocMap)});
        if (!this.iamClient.isTenantIdMatchByToken(tenantId)) {
            throw new ArgumentValidException(ErrorCodeEnum.TOKEN_NOT_MATCH_TENANT_ID);
        }
        boolean checkSecure = SecurityUtil.verifySecure(secure, "RedisOperationService");
        if (!checkSecure) {
            throw new ArgumentValidException(ErrorCodeEnum.SECURE_ERR);
        }
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(eocMap);
        boolean existActiveProject = this.validationService.existActiveProject(actionId, tenantId, eocDto);
        return new ExistActiveProjectVO(existActiveProject);
    }
}

