/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.provider;

import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.ArgumentValidException;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.CrossLevelDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.pojo.request.SyncCrossLevelRuleRequest;
import com.digiwin.athena.cdme.pojo.request.SyncRuleRequest;
import com.digiwin.athena.cdme.provider.IRuleSyncService;
import com.digiwin.athena.cdme.provider.converter.EocDtoConverter;
import com.digiwin.athena.cdme.provider.converter.SyncRuleParamDtoConverter;
import com.digiwin.athena.cdme.repository.model.MonitorOptRecordModel;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.athena.cdme.service.facade.rulesync.ICrossLevelCreateFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.RuleSyncFacadeProxy;
import com.digiwin.athena.cdme.service.srp.db.IMonitorOptRecordService;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeRuleSyncService")
public class RuleSyncService
implements IRuleSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleSyncService.class);
    private final RuleSyncFacadeProxy ruleSyncFacadeProxy;
    private final ICrossLevelCreateFacadeService crossLevelCreateFacadeService;
    private final IMonitorOptRecordService optRecordService;
    private final IIamClient iamClient;

    public RuleSyncService(RuleSyncFacadeProxy ruleSyncFacadeProxy, ICrossLevelCreateFacadeService crossLevelCreateFacadeService, IMonitorOptRecordService optRecordService, IIamClient iamClient) {
        this.ruleSyncFacadeProxy = ruleSyncFacadeProxy;
        this.crossLevelCreateFacadeService = crossLevelCreateFacadeService;
        this.optRecordService = optRecordService;
        this.iamClient = iamClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postMonitorRule(SyncRuleRequest syncRuleRequest) {
        LOGGER.info("\u540c\u6b65\u4fa6\u6d4b\u89c4\u5219\u5165\u53c2:{}", (Object)syncRuleRequest);
        if (StringUtil.isBlank(syncRuleRequest.getRuleId()) || StringUtil.isBlank(syncRuleRequest.getTenantId()) || StringUtil.isBlank(syncRuleRequest.getChangeType())) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        if (!this.iamClient.isTenantIdMatchByToken(syncRuleRequest.getTenantId())) {
            throw new ArgumentValidException(ErrorCodeEnum.TOKEN_NOT_MATCH_TENANT_ID);
        }
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(syncRuleRequest.getEocMap());
        MonitorOptRecordModel monitorOptRecordModel = new MonitorOptRecordModel(syncRuleRequest.getTenantId(), syncRuleRequest.getRuleId(), syncRuleRequest.getChangeType(), eocDto, syncRuleRequest.toString());
        try {
            SyncRuleParamDto ruleDto = SyncRuleParamDtoConverter.convertSyncRuleParamDtoByRequest(syncRuleRequest);
            ResultDto synMonitorRuleResult = this.ruleSyncFacadeProxy.syncMonitorRuleHandler(ruleDto);
            if (MonitorHelper.isResultFail(synMonitorRuleResult)) {
                LOGGER.error("\u540c\u6b65\u4fa6\u6d4b\u89c4\u5219\u5931\u8d25,\u53c2\u6570:{}", (Object)syncRuleRequest);
                throw new BusinessException(synMonitorRuleResult.getCode(), synMonitorRuleResult.getMessage());
            }
            monitorOptRecordModel.setStatus(1);
            String string = synMonitorRuleResult.getMessage();
            return string;
        }
        finally {
            this.optRecordService.save(monitorOptRecordModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postCrossLevelRule(SyncCrossLevelRuleRequest syncCrossLevelRuleRequest) {
        LOGGER.info("\u540c\u6b65\u8de8\u5c42\u7ea7\u4fa6\u6d4b\u89c4\u5219\u5165\u53c2:{}", (Object)syncCrossLevelRuleRequest);
        if (StringUtil.isBlank(syncCrossLevelRuleRequest.getRuleId()) || StringUtil.isBlank(syncCrossLevelRuleRequest.getTenantId()) || CollectionUtil.isEmpty(syncCrossLevelRuleRequest.getNewEocList())) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        syncCrossLevelRuleRequest.getNewEocList().forEach(eoc -> {
            if (CollectionUtil.isEmpty(eoc)) {
                throw new ArgumentValidException(ErrorCodeEnum.CROSS_LEVEL_NEW_EOC_EMPTY);
            }
        });
        if (!this.iamClient.isTenantIdMatchByToken(syncCrossLevelRuleRequest.getTenantId())) {
            throw new ArgumentValidException(ErrorCodeEnum.TOKEN_NOT_MATCH_TENANT_ID);
        }
        CrossLevelDto crossLevelDto = SyncRuleParamDtoConverter.convertCrossLevelDtoByRequest(syncCrossLevelRuleRequest);
        MonitorOptRecordModel optRecord = new MonitorOptRecordModel(crossLevelDto, (Integer)0);
        try {
            ResultDto synMonitorRuleResult = this.crossLevelCreateFacadeService.syncCrossLevelRule(crossLevelDto);
            optRecord.setStatus(BooleanUtils.toInteger((boolean)synMonitorRuleResult.getSuccess()));
            String string = synMonitorRuleResult.getMessage();
            return string;
        }
        finally {
            this.optRecordService.save(optRecord);
        }
    }
}

