/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.config.CdmeEaiProp;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.ServiceResponseUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IEspClient;
import com.digiwin.athena.cdme.service.client.request.EspSdkReq;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="cdmeEspClient")
public class EspClient
extends AbstractExecuteClient
implements IEspClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EspClient.class);
    public static final String OPERATION_MANAGER = "operation_manager";
    private final CdmeEaiProp eaiProp;

    public EspClient(CdmeEaiProp eaiProp) {
        this.eaiProp = eaiProp;
    }

    @Override
    public List<EocDto> getDispatchEoc(String tenantId, String productName) {
        JSONArray dispatchArray = this.getDispatchData(tenantId, productName);
        if (Objects.isNull(dispatchArray)) {
            return Collections.singletonList(new EocDto());
        }
        if (CollectionUtil.isEmpty((Collection)dispatchArray)) {
            return Collections.singletonList(new EocDto());
        }
        ArrayList<EocDto> eocList = new ArrayList<EocDto>();
        for (int i = 0; i < dispatchArray.size(); ++i) {
            JSONObject dispatchEoc = dispatchArray.getJSONObject(i).getJSONObject(OPERATION_MANAGER);
            if (CollectionUtil.isNotEmpty((Map)dispatchEoc)) {
                eocList.add(new EocDto(dispatchEoc.getString("eoc_company_id"), dispatchEoc.getString("eoc_site_id"), dispatchEoc.getString("eoc_region_id")));
                continue;
            }
            eocList.add(new EocDto());
        }
        return eocList;
    }

    private JSONArray getDispatchData(String tenantId, String prodName) {
        HashMap<String, String> dispatchParam = new HashMap<String, String>(4);
        dispatchParam.put("tenant_id", tenantId);
        dispatchParam.put("prod_name", prodName);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ESP\u83b7\u53d6Dispatch\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)JsonUtil.getJsonString(dispatchParam));
        JSONObject jsonObject = this.post(ConfigConstant.ESP_DISPATCH_URL, dispatchParam, DWServiceContext.getContext().getToken(), JSONObject.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ESP\u83b7\u53d6Dispatch\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JsonUtil.getJsonString(jsonObject));
        if (CollectionUtil.isEmpty((Map)jsonObject)) {
            throw new BusinessException(ErrorCodeEnum.GET_DISPATCH_400);
        }
        JSONObject dataObj = jsonObject.getJSONObject("data");
        if (CollectionUtil.isEmpty((Map)dataObj)) {
            return null;
        }
        return dataObj.getJSONArray("dispatch");
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.GET_DISPATCH_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR: {
                return ErrorCodeEnum.GET_DISPATCH_500;
            }
            case BAD_GATEWAY: {
                return ErrorCodeEnum.GET_DISPATCH_502;
            }
            case SERVICE_UNAVAILABLE: {
                return ErrorCodeEnum.GET_DISPATCH_503;
            }
            case GATEWAY_TIMEOUT: {
                return ErrorCodeEnum.GET_DISPATCH_504;
            }
        }
        return ErrorCodeEnum.GET_DISPATCH_OTHER_ERR;
    }

    @Override
    public ResponseModel invokeRestSync(EspSdkReq reqParam) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("token", DWServiceContext.getContext().getToken());
        header.put("routerKey", (String)DWServiceContext.getContext().getRequestHeader().get("routerKey"));
        header.put("digi-middleware-auth-app", ConfigConstant.MULTIPLEAPPENV ? ConfigConstant.MERGED_IAM_APP_TOKEN : ConfigConstant.IAM_APP_TOKEN);
        RequestModel requestModel = this.convertToRequestModel(reqParam, header);
        requestModel.setLanguage((String)DWServiceContext.getContext().getRequestHeader().get("locale"));
        return Invoker.invokeRestSync((RequestModel)requestModel);
    }

    private RequestModel convertToRequestModel(EspSdkReq reqParam, Map<String, String> header) {
        RequestModel requestModel = new RequestModel();
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        requestModel.setHostProd(this.eaiProp.getEaiHostProd());
        requestModel.setHostVer(reqParam.getHostVer());
        requestModel.setHostId(this.eaiProp.getEaiHostId());
        requestModel.setHostAcct(reqParam.getHostAcct());
        requestModel.setTenantId(reqParam.getTenantId());
        requestModel.setServiceProd(reqParam.getServiceProd());
        requestModel.setServiceName(reqParam.getServiceName());
        requestModel.setDatakeyMap(reqParam.getDatakey());
        requestModel.setHeaderMap(header);
        requestModel.setBodyJsonString(reqParam.getBodyJsonString());
        requestModel.setEocMap(reqParam.getEocDto().toUnderLineMap());
        return requestModel;
    }

    @Override
    protected boolean isNeedAuthInfo() {
        return true;
    }

    private ResultDto<JSONObject> callEspSync(EspSdkReq espRequest) {
        ResponseModel responseModel;
        LOGGER.info("[{}-{}]\u4fa6\u6d4b\u8c03\u7528ESP\u8bf7\u6c42\u5165\u53c2:[{}]", new Object[]{espRequest.getDatakey().get("ruleId"), espRequest.getTenantId(), espRequest});
        try {
            responseModel = this.invokeRestSync(espRequest);
        }
        catch (Exception e) {
            LOGGER.error("\u4fa6\u6d4b\u8c03\u7528ESP\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.DATA_CHANGE_GET_500);
        }
        String respContent = responseModel.getBodyJsonString();
        String reqId = responseModel.getReqid();
        LOGGER.info("[{}-{}]\u4fa6\u6d4b\u8c03\u7528ESP\u8fd4\u56de\u7ed3\u679c:[{}]", new Object[]{espRequest.getDatakey().get("ruleId"), espRequest.getTenantId(), respContent});
        JSONObject dataObj = this.getEspRespData(respContent);
        boolean status = this.isSuccessResp(dataObj);
        if (!status) {
            LOGGER.error("ESP \u8fd4\u56de\u72b6\u6001\u4e3a [false],\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)this.getEspRespDesc(dataObj, respContent, reqId));
            return ResultHelper.generateFailResult(ErrorCodeEnum.DATA_CHANGE_GET_500, new JSONObject());
        }
        JSONObject espRespParameter = dataObj.getJSONObject("parameter");
        if (CollectionUtil.isEmpty((Map)espRespParameter)) {
            LOGGER.warn("ESP\u8c03\u7528\u6210\u529f,\u4f46\u8fd4\u56deparameter\u8282\u70b9\u6570\u636e\u4e3a\u7a7a\uff01");
            return ResultHelper.generateFailResult(ErrorCodeEnum.DATA_CHANGE_GET_RES_EMPTY, new JSONObject());
        }
        return ResultHelper.generateResult(true, "ESP\u8c03\u7528\u6210\u529f\uff01", espRespParameter);
    }

    @Override
    public ResultDto<JSONObject> getChangeDataAndMetaInfo(EspSdkReq espRequest) {
        ResultDto<JSONObject> espRespParameter = this.callEspSync(espRequest);
        if (MonitorHelper.isResultFail(espRespParameter)) {
            return espRespParameter;
        }
        JSONArray respObjects = espRespParameter.getData().getJSONArray("response_objects");
        if (CollectionUtil.isEmpty((Collection)respObjects)) {
            LOGGER.warn("ESP\u8c03\u7528\u6210\u529f,\u4f46\u8fd4\u56deresponse_objects\u8282\u70b9\u6570\u636e\u4e3a\u7a7a\uff01");
            return ResultHelper.generateFailResult(ErrorCodeEnum.DATA_CHANGE_GET_RES_EMPTY, new JSONObject());
        }
        return ResultHelper.generateResult(true, "ESP\u8c03\u7528\u6210\u529f\uff01", respObjects.getJSONObject(0));
    }

    @Override
    public ResultDto<JSONArray> getChangeObjects(EspSdkReq espRequest) {
        ResultDto<JSONObject> changeData = this.getChangeDataAndMetaInfo(espRequest);
        if (MonitorHelper.isResultFail(changeData)) {
            return ResultHelper.generateFailResult(changeData.getCode(), changeData.getMessage(), new JSONArray[]{new JSONArray()});
        }
        JSONArray changeObjects = changeData.getData().getJSONArray("change_objects");
        return ResultHelper.generateResult(true, "ESP\u8c03\u7528\u6210\u529f\uff01", changeObjects);
    }

    private boolean isSuccessResp(JSONObject respObj) {
        if (CollectionUtil.isNotEmpty((Map)respObj)) {
            return 0 == respObj.getJSONObject("execution").getIntValue("code");
        }
        return false;
    }

    private JSONObject getEspRespData(String respContent) {
        JSONObject respJsonObject = JsonUtil.getObject(respContent);
        if (CollectionUtil.isNotEmpty((Map)respJsonObject)) {
            JSONObject respObj = respJsonObject.getJSONObject("std_data");
            return ServiceResponseUtil.checkObjEmpty(respObj);
        }
        return new JSONObject();
    }

    private String getEspRespDesc(JSONObject respObj, String respContent, String reqId) {
        if (CollectionUtil.isEmpty((Map)respObj)) {
            return "ESP\u8fd4\u56de\u5f02\u5e38\u7ed3\u679c\u4e3a\uff1a[" + respContent + "]\uff0c\u8bf7\u68c0\u67e5\uff01" + "reqId\uff1a[" + reqId + "]";
        }
        return respObj.getJSONObject("execution").getString("description") + "reqId\uff1a[" + reqId + "]";
    }
}

