/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.client.request.BatchCreateScheduleRequest;
import com.digiwin.athena.cdme.service.client.request.ScheduleBaseRequest;
import com.digiwin.athena.cdme.service.client.request.SyncScheduleRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="cdmeScheduleClient")
public class ScheduleClient
extends AbstractExecuteClient
implements IScheduleClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleClient.class);

    @Override
    public ResultDto createSchedule(List<MonitorRuleDto> ruleDtos, String scheduleStatus) {
        ArrayList<SyncScheduleRequest> batchParams = new ArrayList<SyncScheduleRequest>();
        ruleDtos.forEach(ruleDto -> {
            MonitorRuleModel ruleModel = ruleDto.getRuleModel();
            MonitorTriggerModel triggerModel = ruleDto.getTriggerModel();
            JSONArray triggerParam = JsonUtil.parseArray(triggerModel.getTriggerParam());
            SyncScheduleRequest param = new SyncScheduleRequest(triggerModel.getId(), null, ruleModel.getActionId(), triggerParam, StringUtil.trimToNull(scheduleStatus));
            batchParams.add(param);
        });
        BatchCreateScheduleRequest request = new BatchCreateScheduleRequest(ruleDtos.get(0).getTenantId(), batchParams);
        return this.syncSchedule(request, ConfigConstant.POST_SCHEDULE_URL, HttpMethod.POST, "\u521b\u5efa\u6392\u7a0b");
    }

    @Override
    public ResultDto editSchedule(MonitorRuleDto ruleDto, String scheduleStatus) {
        MonitorRuleModel ruleModel = ruleDto.getRuleModel();
        MonitorTriggerModel triggerModel = ruleDto.getTriggerModel();
        JSONArray triggerParam = JsonUtil.parseArray(triggerModel.getTriggerParam());
        SyncScheduleRequest request = new SyncScheduleRequest(triggerModel.getId(), ruleModel.getTenantId(), ruleModel.getActionId(), triggerParam, StringUtil.trimToNull(scheduleStatus));
        return this.syncSchedule(request, ConfigConstant.POST_SCHEDULE_URL, HttpMethod.PUT, "\u4fee\u6539\u6392\u7a0b");
    }

    @Override
    public ResultDto stopSchedule(String triggerId, String tenantId) {
        ScheduleBaseRequest request = new ScheduleBaseRequest(triggerId, tenantId);
        return this.syncSchedule(request, ConfigConstant.POST_SCHEDULE_URL + "/stop", HttpMethod.POST, "\u6682\u505c\u6392\u7a0b");
    }

    @Override
    public ResultDto startSchedule(String triggerId, String tenantId) {
        ScheduleBaseRequest request = new ScheduleBaseRequest(triggerId, tenantId);
        return this.syncSchedule(request, ConfigConstant.POST_SCHEDULE_URL + "/start", HttpMethod.POST, "\u542f\u7528\u6392\u7a0b");
    }

    @Override
    public ResultDto deleteSchedule(String triggerId, String tenantId) {
        ScheduleBaseRequest request = new ScheduleBaseRequest(triggerId, tenantId);
        return this.syncSchedule(request, ConfigConstant.POST_SCHEDULE_URL, HttpMethod.DELETE, "\u5220\u9664\u6392\u7a0b");
    }

    @Override
    public ResultDto<String> getScheduleStatus(String triggerId, String tenantId, String token) {
        ScheduleBaseRequest request = new ScheduleBaseRequest(triggerId, tenantId);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u6392\u7a0b\u5f15\u64ce\u83b7\u53d6\u6392\u7a0b\u5b9e\u4f8b\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u4e3a:[{}]", (Object)JsonUtil.getJsonString(request));
        JSONObject scheduleResp = this.execute(ConfigConstant.POST_SCHEDULE_URL + "/query", (Object)request, token, JSONObject.class, HttpMethod.POST, new Object[0]);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u6392\u7a0b\u5f15\u64ce\u83b7\u53d6\u6392\u7a0b\u5b9e\u4f8b\u72b6\u6001\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JsonUtil.getJsonString(scheduleResp));
        JSONObject scheduleInfo = scheduleResp.getJSONObject("response");
        if (CollectionUtil.isEmpty((Map)scheduleInfo)) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.SCHEDULE_NOT_EXIST, "SCHEDULE_NOT_EXIST");
        }
        return ResultHelper.generateResult(true, "", scheduleInfo.getString("enable_status"));
    }

    @Override
    public ResultDto<Boolean> isScheduleDisabled(String triggerId, String tenantId, String token) {
        ResultDto<String> statusResult = this.getScheduleStatus(triggerId, tenantId, token);
        if (MonitorHelper.isResultFail(statusResult)) {
            return ResultHelper.generateFailResult(statusResult.getMessage());
        }
        return ResultHelper.generateSuccessResult("N".equals(statusResult.getData()));
    }

    private ResultDto syncSchedule(Object request, String url, HttpMethod httpMethod, String opName) {
        try {
            LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u6392\u7a0b\u5f15\u64ce\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)JsonUtil.getJsonString(request));
            JSONObject scheduleResult = this.execute(url, request, DWServiceContext.getContext().getToken(), JSONObject.class, httpMethod, new Object[0]);
            LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u6392\u7a0b\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JsonUtil.getJsonString(scheduleResult));
            boolean isScheduleSuccess = CollectionUtil.isNotEmpty((Map)scheduleResult);
            if (!isScheduleSuccess) {
                LOGGER.error("\u4fa6\u6d4b\u8c03\u7528\u6392\u7a0b\u5f15\u64ce\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01");
                return ResultHelper.generateFailResult(ErrorCodeEnum.RULE_SCHEDULE_SYNC_FAILED, new Object[0]);
            }
            return ResultHelper.generateSuccessResult(null);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u6392\u7a0b\u6a21\u7ec4{}\u670d\u52a1\u8c03\u7528\u5f02\u5e38", (Object)opName, (Object)e);
            return ResultHelper.generateFailResult(ErrorCodeEnum.RULE_SCHEDULE_SYNC_FAILED, new Object[0]);
        }
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.SCHEDULE_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR: {
                return ErrorCodeEnum.SCHEDULE_500;
            }
            case BAD_GATEWAY: {
                return ErrorCodeEnum.SCHEDULE_502;
            }
            case SERVICE_UNAVAILABLE: {
                return ErrorCodeEnum.SCHEDULE_503;
            }
            case GATEWAY_TIMEOUT: {
                return ErrorCodeEnum.SCHEDULE_504;
            }
        }
        return ErrorCodeEnum.SCHEDULE_OTHER_ERR;
    }
}

