/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.DWResponseUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.SecurityUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.RuleExtensionDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.client.request.ActionMetaDataReq;
import com.digiwin.athena.cdme.service.client.request.ExpireRuleReq;
import com.digiwin.athena.cdme.service.client.request.SyncRuleCallBackReq;
import com.digiwin.athena.cdme.service.client.response.ActionMetaDataRes;
import com.digiwin.athena.cdme.service.client.response.ExpireRuleRes;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="cdmeThemeMapClient")
public class ThemeMapClient
extends AbstractExecuteClient
implements IThemeMapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeMapClient.class);
    public static final String LICENSEKEY_REQUEST_FROM = "requestFrom";
    public static final String LICENSEKEY_TIMESTAMP = "timestamp";
    public static final String LICENSEKEY_KEY = "key";
    private static final String COMPONENT = "component";

    @Override
    public String getTenantSecretKey(String tenantId) {
        Map<String, Object> licenseKeyParam = this.licenseKeyParam(tenantId);
        JSONObject httpRespOjb = this.post(ConfigConstant.POST_THEMEMAP_LICENSEKEY_URL, licenseKeyParam, DWServiceContext.getContext().getToken(), JSONObject.class);
        if (CollectionUtil.isNotEmpty((Map)httpRespOjb) && 200 == httpRespOjb.getIntValue("status")) {
            LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6LicenseKey\u6210\u529f\uff01");
            String data = httpRespOjb.getString("response");
            if (StringUtil.isEmpty(data)) {
                LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6LicenseKey\u4e3a\u7a7a\uff01");
                throw new BusinessException(ErrorCodeEnum.KG_400);
            }
            return SecurityUtil.decodeAES(data);
        }
        LOGGER.error("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6LicenseKey\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a[{}]", (Object)httpRespOjb);
        throw new BusinessException(ErrorCodeEnum.KG_400);
    }

    private Map<String, Object> licenseKeyParam(String tenantId) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        String key = SecurityUtil.getMd5Hex(sb.append(tenantId).append(ConfigConstant.THEMEMAP_LICENSEKEY_REQUEST_FROM).append(timestamp).append(ConfigConstant.THEMEMAP_LICENSEKEY_MD5_KEY).toString());
        param.put("tenantId", tenantId);
        param.put(LICENSEKEY_REQUEST_FROM, ConfigConstant.THEMEMAP_LICENSEKEY_REQUEST_FROM);
        param.put(LICENSEKEY_TIMESTAMP, timestamp);
        param.put(LICENSEKEY_KEY, key);
        return param;
    }

    @Override
    public MonitorRuleDto getRuleInfo(String tenantId, EocDto eocDto, String ruleId) {
        HashMap<String, Object> config = new HashMap<String, Object>(4);
        config.put("tenantId", tenantId);
        config.put("ruleId", ruleId);
        config.put("eocMap", eocDto);
        HashMap<String, HashMap<String, Object>> param = new HashMap<String, HashMap<String, Object>>(1);
        param.put("config", config);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6\u4fa6\u6d4b\u89c4\u5219\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)JsonUtil.getJsonString(param));
        JSONObject responseObj = this.post(ConfigConstant.THEMEMAP_MONITORRULE_URL, param, DWServiceContext.getContext().getToken(), JSONObject.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6\u4fa6\u6d4b\u89c4\u5219\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JsonUtil.getJsonString(responseObj));
        if (CollectionUtil.isEmpty((Map)responseObj)) {
            LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{},thememap\u4fa6\u6d4b\u89c4\u5219\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a\uff01", (Object)JsonUtil.getJsonString(param));
            throw new BusinessException(ErrorCodeEnum.KG_400);
        }
        JSONObject ruleObj = responseObj.getJSONObject("response");
        if (CollectionUtil.isEmpty((Map)ruleObj)) {
            LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{},thememap\u4fa6\u6d4b\u89c4\u5219\u8fd4\u56deresponse\u8282\u70b9\u4e3a\u7a7a\uff01", (Object)JsonUtil.getJsonString(param));
            throw new BusinessException(ErrorCodeEnum.KG_400);
        }
        return this.parseRuleObj(ruleObj);
    }

    @Override
    public MonitorCdcRuleDto getCdcRuleInfo(String tenantId, EocDto eocDto, String ruleId) {
        HashMap<String, Object> config = new HashMap<String, Object>(4);
        config.put("tenantId", tenantId);
        config.put("ruleId", ruleId);
        config.put("eocMap", eocDto);
        HashMap<String, HashMap<String, Object>> param = new HashMap<String, HashMap<String, Object>>(1);
        param.put("config", config);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6\u4fa6\u6d4b\u89c4\u5219\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)JsonUtil.getJsonString(param));
        JSONObject responseObj = this.post(ConfigConstant.THEMEMAP_MONITORRULE_URL, param, DWServiceContext.getContext().getToken(), JSONObject.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6\u4fa6\u6d4b\u89c4\u5219\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JsonUtil.getJsonString(responseObj));
        if (CollectionUtil.isEmpty((Map)responseObj)) {
            LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{},thememap\u4fa6\u6d4b\u89c4\u5219\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a\uff01", (Object)JsonUtil.getJsonString(param));
            throw new BusinessException(ErrorCodeEnum.KG_400);
        }
        JSONObject ruleObj = responseObj.getJSONObject("response");
        if (CollectionUtil.isEmpty((Map)ruleObj)) {
            LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{},thememap\u4fa6\u6d4b\u89c4\u5219\u8fd4\u56deresponse\u8282\u70b9\u4e3a\u7a7a\uff01", (Object)JsonUtil.getJsonString(param));
            throw new BusinessException(ErrorCodeEnum.KG_400);
        }
        return this.parseCdcRuleObj(ruleObj);
    }

    private MonitorCdcRuleDto parseCdcRuleObj(JSONObject ruleObj) {
        MonitorRuleCdcModel ruleModel = new MonitorRuleCdcModel(ruleObj);
        String category = ruleObj.getString("category");
        ruleObj.fluentRemove((Object)"rule_id").fluentRemove((Object)"tenant_id").fluentRemove((Object)"action_type").fluentRemove((Object)"action_id").fluentRemove((Object)"product_name").fluentRemove((Object)"standard_polling_rules").fluentRemove((Object)"monitor_action_id").fluentRemove((Object)"category").fluentRemove((Object)"product_uid").fluentRemove((Object)"extension");
        ruleModel.setActionParams(ruleObj.getJSONArray("action_params").toJSONString());
        ruleModel.setChangeType(ruleObj.getString("change_type"));
        ruleModel.setEocCompanyId(StringUtil.emptyToNull(ruleObj.getString("eoc_company_id")));
        ruleModel.setEocSiteId(StringUtil.emptyToNull(ruleObj.getString("eoc_site_id")));
        ruleModel.setStartTime(LocalTimeUtil.parseTime(ruleObj.getString("start_time")));
        if ("MQTT".equals(category)) {
            ruleModel.setTableName(ruleObj.getString("mqttTopic"));
            ruleModel.setDbName(ruleObj.getString("mqttSource"));
            if (CollectionUtil.isNotEmpty((Collection)ruleObj.getJSONArray("conversionFilterCondition"))) {
                ruleModel.setConversionFilterCondition(ruleObj.getJSONArray("conversionFilterCondition").toJSONString());
            } else {
                ruleModel.setConversionFilterCondition(null);
            }
            if (Objects.isNull(ruleModel.getStartTime())) {
                ruleModel.setStartTime(LocalTimeUtil.now());
            }
            if (Objects.isNull(ruleObj.getJSONArray("filter_condition"))) {
                ruleModel.setFilterCondition(null);
            } else {
                ruleModel.setFilterCondition(ruleObj.getJSONArray("filter_condition").toJSONString());
            }
            ruleModel.setCategory(category);
        } else {
            ruleModel.setTableName(ruleObj.getString("table_name"));
            ruleModel.setChangeFields(ruleObj.getJSONArray("change_fields").toJSONString());
            ruleModel.setFilterCondition(ruleObj.getJSONArray("filter_condition").toJSONString());
        }
        return new MonitorCdcRuleDto(ruleModel);
    }

    private MonitorRuleDto parseRuleObj(JSONObject ruleObj) {
        JSONObject extensionConfig;
        MonitorRuleModel ruleModel = new MonitorRuleModel(ruleObj);
        MonitorTriggerModel triggerModel = new MonitorTriggerModel();
        if (!"cdmeREPORT".equals(ruleModel.getCategory()) && !"MQTT".equals(ruleModel.getCategory())) {
            JSONArray triggerParam = ruleObj.getJSONArray("standard_polling_rules");
            if (CollectionUtil.isEmpty((Collection)triggerParam)) {
                throw new BusinessException(ErrorCodeEnum.RULE_SCHEDULE_EMPTY);
            }
            triggerModel = new MonitorTriggerModel(ruleModel.getRuleId(), ruleModel.getTenantId(), triggerParam.toJSONString());
        }
        RuleExtensionDto extensionDto = CollectionUtil.isEmpty((Map)(extensionConfig = ruleObj.getJSONObject("extension"))) ? new RuleExtensionDto() : (RuleExtensionDto)extensionConfig.toJavaObject(RuleExtensionDto.class);
        ruleObj.fluentRemove((Object)"rule_id").fluentRemove((Object)"tenant_id").fluentRemove((Object)"action_type").fluentRemove((Object)"action_id").fluentRemove((Object)"product_name").fluentRemove((Object)"standard_polling_rules").fluentRemove((Object)"monitor_action_id").fluentRemove((Object)"category").fluentRemove((Object)"product_uid").fluentRemove((Object)"extension");
        ruleModel.setMonitorRule(JsonUtil.getJsonString(ruleObj, SerializerFeature.WriteMapNullValue));
        return new MonitorRuleDto(ruleModel, triggerModel, extensionDto);
    }

    @Override
    public ActionMetaDataRes getActionMetaData(String actionId) {
        ActionMetaDataReq requestParam = new ActionMetaDataReq(actionId);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6action\u5143\u6570\u636e\u8bf7\u6c42\u53c2\u6570:{}", (Object)requestParam);
        JSONObject responseObj = this.post(ConfigConstant.THEMEMAP_ACTIONMETADATA_URL, requestParam, DWServiceContext.getContext().getToken(), JSONObject.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6action\u5143\u6570\u636e\u8fd4\u56de\u7ed3\u679c:{}", (Object)responseObj);
        ResultDto<ActionMetaDataRes> rs = DWResponseUtil.convertResponse(responseObj, ActionMetaDataRes.class);
        if (!rs.getSuccess()) {
            throw new BusinessException(ErrorCodeEnum.KG_400);
        }
        return rs.getData();
    }

    @Override
    public ResultDto<Void> syncRuleCallBack(String transactionId, String ruleId, boolean syncSuccess, String errorMsg) {
        try {
            String success = syncSuccess ? "success" : "failure";
            SyncRuleCallBackReq req = new SyncRuleCallBackReq(transactionId, ruleId, success, errorMsg);
            HashMap<String, SyncRuleCallBackReq> param = new HashMap<String, SyncRuleCallBackReq>();
            param.put("syncResult", req);
            LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u56de\u8c03\u540c\u6b65\u89c4\u5219\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570:{}", (Object)req);
            this.post(ConfigConstant.THEMEMAP_SYNC_RULE_CALLBACK_URL, param, DWServiceContext.getContext().getToken(), JSONObject.class);
            LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u56de\u8c03\u540c\u6b65\u89c4\u5219\u7ed3\u679c\u6210\u529f");
        }
        catch (DWRuntimeException e) {
            LOGGER.error("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u56de\u8c03\u540c\u6b65\u89c4\u5219\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            return ResultHelper.generateFailResult(e.getErrorCode(), null);
        }
        catch (Exception e) {
            LOGGER.error("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u56de\u8c03\u540c\u6b65\u89c4\u5219\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            return ResultHelper.generateFailResult(ErrorCodeEnum.KG_OTHER_ERR, new Void[0]);
        }
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public ExpireRuleRes getExpireRule(ExpireRuleReq expireRuleReq) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("tenantId", expireRuleReq.getTenantId());
        param.put("appCode", expireRuleReq.getAppCode());
        param.put("eventType", expireRuleReq.getEventType());
        param.put(COMPONENT, Arrays.asList("MonitorRule"));
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6\u8fc7\u671f\u5e94\u7528\u89c4\u5219\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)JsonUtil.getJsonString(param));
        JSONObject responseObj = this.post(ConfigConstant.THEMEMAP_EXPIRE_RULE_URL, param, DWServiceContext.getContext().getToken(), JSONObject.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ThemeMap\u83b7\u53d6\u8fc7\u671f\u5e94\u7528\u89c4\u5219\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JsonUtil.getJsonString(responseObj));
        ResultDto<ExpireRuleRes> rs = DWResponseUtil.convertResponse(responseObj, ExpireRuleRes.class);
        if (!rs.getSuccess()) {
            throw new BusinessException(ErrorCodeEnum.KG_400);
        }
        return rs.getData();
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.KG_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR: {
                return ErrorCodeEnum.KG_500;
            }
            case BAD_GATEWAY: {
                return ErrorCodeEnum.KG_502;
            }
            case SERVICE_UNAVAILABLE: {
                return ErrorCodeEnum.KG_503;
            }
            case GATEWAY_TIMEOUT: {
                return ErrorCodeEnum.KG_504;
            }
        }
        return ErrorCodeEnum.KG_OTHER_ERR;
    }
}

