/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.dea.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.TimeRangeDto;
import com.digiwin.athena.cdme.pojo.request.DeaDataRequest;
import com.digiwin.athena.cdme.pojo.vo.DeaResultVo;
import com.digiwin.athena.cdme.pojo.vo.SqlReturnMetaInfoVo;
import com.digiwin.athena.cdme.service.client.IEspClient;
import com.digiwin.athena.cdme.service.client.request.EspSdkReq;
import com.digiwin.athena.cdme.service.facade.dea.IDeaFacadeService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="cdmeDeaFacadeServiceImpl")
public class DeaFacadeServiceImpl
implements IDeaFacadeService {
    private final IEspClient espClient;
    private final String ruleId = "eb2715bf-6f8b-414e-9187-bb568700a698";

    public DeaFacadeServiceImpl(IEspClient espClient) {
        this.espClient = espClient;
    }

    @Override
    public DeaResultVo getDataByDea(DeaDataRequest request) {
        JSONObject rule = JsonUtil.getObject(request.getRule());
        JSONArray dynamicConditions = this.convertToDynamicConditions(request, rule);
        List<EocDto> eocList = this.espClient.getDispatchEoc(request.getTenantId(), request.getProductName());
        DeaResultVo deaResultDto = new DeaResultVo();
        eocList.stream().forEach(eocDto -> {
            EspSdkReq espSdkReq = this.buildDataChangeSqlGetRequest(request, (EocDto)eocDto, "eb2715bf-6f8b-414e-9187-bb568700a698", rule, dynamicConditions);
            ResultDto<JSONObject> espResp = this.espClient.getChangeDataAndMetaInfo(espSdkReq);
            if (MonitorHelper.isResultFail(espResp)) {
                throw new BusinessException(ErrorCodeEnum.DATA_CHANGE_GET_400);
            }
            JSONArray changeObjects = espResp.getData().getJSONArray("change_objects");
            this.addResultData(deaResultDto, changeObjects);
            if (CollectionUtil.isEmpty(deaResultDto.getMetaInfo())) {
                deaResultDto.setMetaInfo(espResp.getData().getJSONArray("meta_info").toJavaList(SqlReturnMetaInfoVo.class));
            }
        });
        return deaResultDto;
    }

    private JSONArray convertToDynamicConditions(DeaDataRequest request, JSONObject rule) {
        LocalDateTime nowTime = LocalDateTime.now();
        LocalDateTime start = StringUtil.isEmpty(request.getStartTime()) ? nowTime : LocalTimeUtil.parseTime(request.getStartTime());
        LocalDateTime end = StringUtil.isEmpty(request.getEndTime()) ? nowTime : LocalTimeUtil.parseTime(request.getEndTime());
        TimeRangeDto customTimeDto = new TimeRangeDto(start, end);
        return MonitorHelper.transformToDynamicCondition(MonitorHelper.parseDynamicParams(rule, "cdmeSQL_SCRIPT", customTimeDto));
    }

    private void addResultData(DeaResultVo deaResultDto, JSONArray data) {
        JSONArray changeObjects = deaResultDto.getChangeObjects();
        if (null == changeObjects) {
            changeObjects = new JSONArray();
            deaResultDto.setChangeObjects(changeObjects);
        }
        if (CollectionUtil.isNotEmpty((Collection)data)) {
            changeObjects.addAll((Collection)data);
        }
    }

    private EspSdkReq buildDataChangeSqlGetRequest(DeaDataRequest request, EocDto eocDto, String ruleId, JSONObject rule, JSONArray dynamicConditions) {
        return MonitorHelper.buildDataChangeSqlGetRequest(ruleId, request.getTenantId(), request.getProductName(), dynamicConditions, rule, eocDto);
    }
}

