/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.execution.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.IExecutionClient;
import com.digiwin.athena.cdme.service.client.IScwokerClient;
import com.digiwin.athena.cdme.service.client.ITaskEngineClient;
import com.digiwin.athena.cdme.service.client.impl.IamClient;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="cdmeActionProxy")
public class ActionProxy {
    private static final String DATAPULLING_ACTION = "datapulling";
    private static final String TASK_ACTION = "task";
    private static final String SERVICECOMPOSER_ACTION = "serviceComposer";
    private final IExecutionClient executionClient;
    private final IScwokerClient scwokerClient;
    private final ITaskEngineClient taskEngineClient;
    private final IamClient iamClient;

    public ActionProxy(IExecutionClient executionClient, IScwokerClient scwokerClient, ITaskEngineClient taskEngineClient, IamClient iamClient) {
        this.executionClient = executionClient;
        this.scwokerClient = scwokerClient;
        this.taskEngineClient = taskEngineClient;
        this.iamClient = iamClient;
    }

    public ResultDto<JSON> doAction(MonitorRuleModel ruleModel, EocDto eocDto, JSONArray monitorData, Map<String, JSONObject> allParams) {
        if (SERVICECOMPOSER_ACTION.equalsIgnoreCase(ruleModel.getActionType())) {
            this.initLocale();
            return this.scwokerClient.processService(ruleModel.getActionId(), ruleModel.getTenantId(), eocDto, monitorData);
        }
        if (TASK_ACTION.equalsIgnoreCase(ruleModel.getActionType())) {
            this.initLocale();
            return this.taskEngineClient.createProject(ruleModel.getActionId(), eocDto, monitorData);
        }
        Map<String, Object> param = MonitorHelper.buildExecutionParam(ruleModel, eocDto, monitorData, allParams, "action");
        boolean needSignSource = !"cdmeREPORT".equalsIgnoreCase(ruleModel.getCategory());
        return this.executionClient.callExecution(param, needSignSource);
    }

    private void initLocale() {
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (StringUtil.isBlank(locale)) {
            locale = this.iamClient.getDefaultLocale();
            DWServiceContext.getContext().getRequestHeader().put("locale", locale);
        }
    }
}

