/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorIntervelLimitService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorIntervelLimitService")
public class MonitorIntervelLimitService
implements IMonitorIntervelLimitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorIntervelLimitService.class);
    private final ICacheService cacheService;

    public MonitorIntervelLimitService(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public boolean canProcess(MonitorRuleModel ruleModel) {
        JSONObject rule = JsonUtil.getObject(ruleModel.getMonitorRule());
        Integer interval = rule.getInteger("chill_interval");
        LOGGER.info("[\u4fa6\u6d4b\u5f15\u64ce\u83b7\u53d6\u65f6\u95f4\u95f4\u9694\u9650\u5236]:interval:[{}]", (Object)interval);
        if (null == interval || interval <= 0) {
            return true;
        }
        String key = MonitorHelper.buildIntervelLimitKey(ruleModel);
        Object v = this.cacheService.get(key);
        LOGGER.info("[\u4fa6\u6d4b\u5f15\u64ce\u83b7\u53d6\u65f6\u95f4\u95f4\u9694\u9650\u5236]:interval:[{}]", (Object)JsonUtil.getJsonString(v));
        LOGGER.info("[\u4fa6\u6d4b\u5f15\u64ce\u8bbe\u7f6e\u65f6\u95f4\u95f4\u9694\u9650\u5236\u6210\u529f:{},[{}]", (Object)key, (Object)JsonUtil.getJsonString(v));
        return null == v;
    }

    @Override
    public void setLimiter(MonitorRuleModel ruleModel) {
        JSONObject rule = JsonUtil.getObject(ruleModel.getMonitorRule());
        Integer interval = rule.getInteger("chill_interval");
        LOGGER.info("[\u4fa6\u6d4b\u5f15\u64ce\u8bbe\u7f6e\u65f6\u95f4\u95f4\u9694\u9650\u5236]:interval:[{}]", (Object)interval);
        if (null == interval || interval <= 0) {
            return;
        }
        String key = MonitorHelper.buildIntervelLimitKey(ruleModel);
        this.cacheService.set(key, 1, interval);
        LOGGER.info("[\u4fa6\u6d4b\u5f15\u64ce\u8bbe\u7f6e\u65f6\u95f4\u95f4\u9694\u9650\u5236\u6210\u529f:{}", (Object)key);
    }
}

