/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.ops.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.config.CdmeApplicationProp;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.handler.MqttClientSingle;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.MqttUtil;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.RuleOpsDto;
import com.digiwin.athena.cdme.provider.MqttOpsService;
import com.digiwin.athena.cdme.repository.model.MonitorRecordModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.repository.model.MqttServerConfigModel;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRecordService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorTriggerInsService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorTriggerService;
import com.digiwin.athena.cdme.service.srp.db.IMqttServerConfigService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cdmeRuleTriggerOperatorFacadeService")
public class RuleTriggerOperatorFacadeService
implements IRuleTriggerOperatorFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleTriggerOperatorFacadeService.class);
    private final IMonitorRuleService ruleService;
    private final IMonitorRuleCdcService ruleCdcService;
    private final IMonitorTriggerService triggerService;
    private final IMonitorTriggerInsService triggerInsService;
    private final IMqttServerConfigService mqttServerConfigService;
    private final IMonitorRecordService recordService;
    private CdmeApplicationProp applicationProp;
    private final ICacheService redisService;
    @Autowired
    @Qualifier(value="cdmeMqttOpsService")
    private MqttOpsService mqttOpsService;

    public RuleTriggerOperatorFacadeService(IMonitorRuleService ruleService, IMonitorTriggerService triggerService, IMonitorRuleCdcService ruleCdcService, IMonitorTriggerInsService triggerInsService, IMqttServerConfigService mqttServerConfigService, CdmeApplicationProp applicationProp, IMonitorRecordService recordService, ICacheService redisService) {
        this.ruleService = ruleService;
        this.ruleCdcService = ruleCdcService;
        this.triggerService = triggerService;
        this.triggerInsService = triggerInsService;
        this.mqttServerConfigService = mqttServerConfigService;
        this.applicationProp = applicationProp;
        this.recordService = recordService;
        this.redisService = redisService;
    }

    @Override
    public MonitorRuleDto queryRuleDetailByRuleId(String ruleId, String tenantId, EocDto eocDto) {
        MonitorRuleDto ruleDto = new MonitorRuleDto();
        MonitorRuleModel ruleModel = this.ruleService.getByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto);
        if (null == ruleModel) {
            return ruleDto;
        }
        ruleDto.setRuleModel(ruleModel);
        if (StringUtil.isNotBlank(ruleModel.getTriggerId())) {
            MonitorTriggerModel triggerModel = this.triggerService.getByTriggerId(ruleModel.getTriggerId());
            ruleDto.setTriggerModel(triggerModel);
        }
        return ruleDto;
    }

    @Override
    public MonitorCdcRuleDto queryCdcRuleDetailByRuleId(String ruleId, String tenantId, EocDto eocDto) {
        MonitorCdcRuleDto ruleDto = new MonitorCdcRuleDto();
        MonitorRuleCdcModel ruleModel = this.ruleCdcService.getByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto);
        if (null == ruleModel) {
            return ruleDto;
        }
        ruleDto.setRuleModel(ruleModel);
        return ruleDto;
    }

    @Override
    public MonitorCdcRuleDto getByRuleIdAndTenantIdAndEocUnStatus(String ruleId, String tenantId, EocDto eocDto) {
        MonitorCdcRuleDto ruleDto = new MonitorCdcRuleDto();
        MonitorRuleCdcModel ruleModel = this.ruleCdcService.getByRuleIdAndTenantIdAndEocUnStatus(ruleId, tenantId, eocDto);
        if (null == ruleModel) {
            return ruleDto;
        }
        ruleDto.setRuleModel(ruleModel);
        return ruleDto;
    }

    @Override
    public MonitorCdcRuleDto queryCdcRuleDetailByRuleIdAndTenantId(String ruleId, String tenantId, EocDto eocDto) {
        MonitorCdcRuleDto ruleDto = new MonitorCdcRuleDto();
        MonitorRuleCdcModel ruleModel = this.ruleCdcService.getByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto);
        if (null == ruleModel) {
            return ruleDto;
        }
        ruleDto.setRuleModel(ruleModel);
        return ruleDto;
    }

    @Override
    public MonitorCdcRuleDto queryRuleDetailByRuleIdIgnoreIsEnable(String ruleId, String tenantId, EocDto eocDto) {
        MonitorCdcRuleDto ruleDto = new MonitorCdcRuleDto();
        MonitorRuleCdcModel ruleModel = this.ruleCdcService.queryCdcRuleDetailByRuleIdAndTenantId(ruleId, tenantId, eocDto);
        if (null == ruleModel) {
            return ruleDto;
        }
        ruleDto.setRuleModel(ruleModel);
        return ruleDto;
    }

    @Override
    @Transactional(value="dw-transactionManager")
    public ResultDto<Void> handleBacktrackDate(String ruleId, String tenantId, EocDto eocDto, String backtrackDate) {
        if (StringUtil.isBlank(ruleId) || StringUtil.isBlank(tenantId) || StringUtil.isBlank(backtrackDate)) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.PARAM_EMPTY_ERR, new Void[0]);
        }
        MonitorRuleDto ruleDto = this.queryRuleDetailByRuleId(ruleId, tenantId, eocDto);
        if (null == ruleDto.getRuleModel()) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.RULE_NOT_EXISTS, new Void[0]);
        }
        if (null == ruleDto.getTriggerModel()) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.TRIGGER_NOT_EXISTS, new Void[0]);
        }
        LocalDateTime backTrackDateTime = LocalTimeUtil.parseTime(backtrackDate);
        MonitorTriggerModel triggerModel = ruleDto.getTriggerModel();
        MonitorTriggerModel triggerUpdateBean = new MonitorTriggerModel();
        triggerUpdateBean.setId(triggerModel.getId());
        triggerUpdateBean.setKid(triggerModel.getKid());
        triggerUpdateBean.setLastMonitorTime(backTrackDateTime);
        triggerUpdateBean.setUpdateTime(LocalDateTime.now());
        this.triggerService.edit(triggerUpdateBean);
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public ResultDto<Void> saveCdcRule(MonitorRuleDto monitorRuleDto, EocDto eocDto) {
        MonitorRuleModel ruleModel = monitorRuleDto.getRuleModel();
        MonitorRuleCdcModel ruleCdcModel = new MonitorRuleCdcModel();
        JSONObject monitorRule = JsonUtil.getObject(ruleModel.getMonitorRule());
        ruleCdcModel.setCreateTime(LocalDateTime.now());
        ruleCdcModel.setStartTime(LocalTimeUtil.parseTime(monitorRule.getString("start_time")));
        ruleCdcModel.setActionId(ruleModel.getActionId());
        ruleCdcModel.setActionParams(monitorRule.getJSONArray("action_params").toJSONString());
        ruleCdcModel.setActionType(ruleModel.getActionType());
        ruleCdcModel.setChangeType(monitorRule.getString("change_type"));
        ruleCdcModel.setEocCompanyId(StringUtil.emptyToNull(eocDto.getEocCompanyId()));
        ruleCdcModel.setEocSiteId(StringUtil.emptyToNull(eocDto.getEocSiteId()));
        ruleCdcModel.setProductName(ruleModel.getProductName());
        ruleCdcModel.setRuleId(ruleModel.getRuleId());
        ruleCdcModel.setTenantId(ruleModel.getTenantId());
        ruleCdcModel.setTenantSid(String.valueOf(DWServiceContext.getContext().getProfile().get("tenantSid")));
        ruleCdcModel.setCategory(ruleModel.getCategory());
        if ("MQTT".equals(ruleModel.getCategory())) {
            ruleCdcModel.setTableName(monitorRule.getString("mqttTopic"));
            ruleCdcModel.setDbName(monitorRule.getString("mqttSource"));
            if (CollectionUtils.isNotEmpty((Collection)monitorRule.getJSONArray("conversionFilterCondition"))) {
                ruleCdcModel.setConversionFilterCondition(monitorRule.getJSONArray("conversionFilterCondition").toJSONString());
            }
            if (Objects.isNull(ruleCdcModel.getStartTime())) {
                ruleCdcModel.setStartTime(LocalTimeUtil.now());
            }
            if (Objects.isNull(ruleCdcModel.getChangeType())) {
                ruleCdcModel.setChangeType("create");
            }
            if (!Objects.isNull(monitorRule.getJSONArray("filter_condition"))) {
                ruleCdcModel.setFilterCondition(monitorRule.getJSONArray("filter_condition").toJSONString());
            }
        } else {
            ruleCdcModel.setTableName(monitorRule.getString("table_name"));
            ruleCdcModel.setChangeFields(monitorRule.getJSONArray("change_fields").toJSONString());
            ruleCdcModel.setFilterCondition(monitorRule.getJSONArray("filter_condition").toJSONString());
        }
        ruleCdcModel.setValid(StringUtil.isEmpty(monitorRule.getString("valid")) ? "ENABLED" : monitorRule.getString("valid"));
        boolean result = this.ruleCdcService.save(ruleCdcModel);
        if (result) {
            String cdcRuleKey = MonitorHelper.buildCdcRuleKey(ruleCdcModel.getTenantId(), null == ruleCdcModel.getDbName() ? "" : ruleCdcModel.getDbName(), ruleCdcModel.getTableName(), ruleCdcModel.getChangeType());
            String subKey = MonitorHelper.buildCdcRuleSubKey(ruleCdcModel);
            this.redisService.hPut(cdcRuleKey, subKey, JsonUtil.getJsonString(ruleCdcModel));
            if ("MQTT".equals(ruleModel.getCategory())) {
                try {
                    IMqttAsyncClient mqttAsyncClient = MqttClientSingle.getInstance().pull(ruleCdcModel.getDbName());
                    MqttServerConfigModel mqttServerConfigModel = MqttClientSingle.getInstance().pullConfig(ruleCdcModel.getDbName());
                    if (!Objects.isNull(mqttAsyncClient)) {
                        mqttAsyncClient.subscribe(MqttUtil.getTopicByDbname(ruleCdcModel.getTenantSid(), ruleCdcModel.getTableName(), ruleCdcModel.getDbName(), mqttServerConfigModel.getZone()), mqttServerConfigModel.getOps());
                    } else {
                        this.mqttOpsService.initMqttByBusinessSource(ruleCdcModel.getDbName());
                        IMqttAsyncClient mqttAsyncClient1 = MqttClientSingle.getInstance().pull(ruleCdcModel.getDbName());
                        MqttServerConfigModel mqttServerConfigModel1 = MqttClientSingle.getInstance().pullConfig(ruleCdcModel.getDbName());
                        if (!Objects.isNull(mqttAsyncClient1)) {
                            mqttAsyncClient1.subscribe(MqttUtil.getTopicByDbname(ruleCdcModel.getTenantSid(), ruleCdcModel.getTableName(), ruleCdcModel.getDbName(), mqttServerConfigModel1.getZone()), mqttServerConfigModel1.getOps());
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u521b\u5efa\u4fa6\u6d4b\u89c4\u5219\u65f6\u8ba2\u9605Topic\u5931\u8d25\uff0cRuleId=[{}]\uff0cTenantId=[{}]\uff0cTopic=[{}]\uff0c\u5f02\u5e38=[{}]", new Object[]{ruleCdcModel.getRuleId(), ruleCdcModel.getTenantId(), ruleCdcModel.getTableName(), e});
                }
            }
        }
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public ResultDto<Void> modifyRule(MonitorRuleDto monitorRuleDto) {
        MonitorRuleModel ruleModel;
        if (!"cdmeREPORT".equals(monitorRuleDto.getRuleModel().getCategory()) && monitorRuleDto.getTriggerModel() != null) {
            this.triggerService.edit(monitorRuleDto.getTriggerModel());
        }
        if ((ruleModel = monitorRuleDto.getRuleModel()).getPageSize() == null || ruleModel.getPageSize() < 1 || ruleModel.getPageSize() > this.applicationProp.getMonitorPageSize()) {
            ruleModel.setPageSize(null);
        }
        this.ruleService.edit(ruleModel);
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public ResultDto<Void> modifyCdcRule(MonitorCdcRuleDto monitorRuleDto) {
        boolean result = this.ruleCdcService.edit(monitorRuleDto.getRuleModel());
        if (result) {
            MonitorRuleCdcModel ruleCdcModel = monitorRuleDto.getRuleModel();
            List<String> dbNames = this.getDbNames();
            String cdcRuleKey = dbNames.contains(ruleCdcModel.getDbName()) ? MonitorHelper.buildCdcRuleKey(ruleCdcModel.getTenantId(), ruleCdcModel.getDbName(), ruleCdcModel.getTableName(), ruleCdcModel.getChangeType()) : MonitorHelper.buildCdcRuleKey(ruleCdcModel.getTenantId(), "", ruleCdcModel.getTableName(), ruleCdcModel.getChangeType());
            String subKey = MonitorHelper.buildCdcRuleSubKey(ruleCdcModel);
            this.redisService.hPut(cdcRuleKey, subKey, JsonUtil.getJsonString(ruleCdcModel));
        }
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public List<MonitorRuleModel> queryRuleByRuleIdAndTenantId(String ruleId, String tenantId) {
        return this.ruleService.listByRuleIdAndTenantId(ruleId, tenantId);
    }

    @Override
    public ResultDto<Void> deleteRule(MonitorRuleDto ruleDto, EocDto eocDto) {
        this.ruleService.deleteByRuleIdAndTenantIdAndEoc(ruleDto.getRuleModel().getRuleId(), ruleDto.getRuleModel().getTenantId(), eocDto);
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public ResultDto<Void> deleteCdcRule(MonitorCdcRuleDto ruleDto, EocDto eocDto) {
        boolean result = this.ruleCdcService.deleteByRuleIdAndTenantIdAndEoc(ruleDto.getRuleModel().getRuleId(), ruleDto.getRuleModel().getTenantId(), eocDto);
        if (result) {
            List<MonitorRuleCdcModel> cdcRules;
            MonitorRuleCdcModel ruleCdcModel = ruleDto.getRuleModel();
            List<String> dbNames = this.getDbNames();
            String cdcRuleKey = dbNames.contains(ruleCdcModel.getDbName()) ? MonitorHelper.buildCdcRuleKey(ruleCdcModel.getTenantId(), ruleCdcModel.getDbName(), ruleCdcModel.getTableName(), ruleCdcModel.getChangeType()) : MonitorHelper.buildCdcRuleKey(ruleCdcModel.getTenantId(), "", ruleCdcModel.getTableName(), ruleCdcModel.getChangeType());
            String subKey = MonitorHelper.buildCdcRuleSubKey(ruleCdcModel);
            this.redisService.hDelete(cdcRuleKey, subKey);
            if ("MQTT".equals(ruleCdcModel.getCategory()) && CollectionUtils.isEmpty(cdcRules = this.ruleCdcService.getByTenantIdAndTableAndChangeType(ruleCdcModel.getTenantId(), ruleCdcModel.getTableName(), "create"))) {
                try {
                    IMqttAsyncClient mqttAsyncClient = MqttClientSingle.getInstance().pull(ruleCdcModel.getDbName());
                    MqttServerConfigModel mqttServerConfigModel = MqttClientSingle.getInstance().pullConfig(ruleCdcModel.getDbName());
                    if (!Objects.isNull(mqttAsyncClient)) {
                        mqttAsyncClient.unsubscribe(MqttUtil.getTopicByDbname(ruleCdcModel.getTenantSid(), ruleCdcModel.getTableName(), ruleCdcModel.getDbName(), mqttServerConfigModel.getZone()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u5220\u9664\u4fa6\u6d4b\u89c4\u5219\u65f6\u53d6\u6d88\u8ba2\u9605Topic\u5931\u8d25\uff0cRuleId=[{}]\uff0cTenantId=[{}]\uff0cTopic=[{}]\uff0c\u5f02\u5e38=[{}]", new Object[]{ruleCdcModel.getRuleId(), ruleCdcModel.getTenantId(), ruleCdcModel.getTableName(), e});
                }
            }
        }
        return ResultHelper.generateSuccessResult(null);
    }

    private List<String> getDbNames() {
        return this.mqttServerConfigService.getbusinessSourcesList();
    }

    @Override
    public ResultDto<Void> saveTriggerIns(MonitorTriggerInsModel insModel) {
        this.triggerInsService.save(insModel);
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public List<MonitorTriggerInsModel> queryTriggerInsByTriggerId(String triggerId) {
        return this.triggerInsService.listByTriggerId(triggerId);
    }

    @Override
    public List<RuleOpsDto> listRuleDetailByRuleIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        List<MonitorRuleModel> ruleModelList = this.ruleService.listByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto);
        if (CollectionUtil.isEmpty(ruleModelList)) {
            return null;
        }
        ArrayList<RuleOpsDto> ruleOpsDtoList = new ArrayList<RuleOpsDto>();
        for (MonitorRuleModel ruleModel : ruleModelList) {
            MonitorTriggerModel triggerModel = null;
            if (!"cdmeREPORT".equals(ruleModel.getCategory())) {
                triggerModel = this.triggerService.getByTriggerId(ruleModel.getTriggerId());
            }
            if (null == triggerModel) {
                ruleOpsDtoList.add(this.buildRuleOpsDto(ruleModel, null, null));
                continue;
            }
            List<MonitorTriggerInsModel> insList = this.triggerInsService.listByTriggerId(triggerModel.getId());
            if (CollectionUtil.isEmpty(insList)) {
                ruleOpsDtoList.add(this.buildRuleOpsDto(ruleModel, triggerModel, null));
                continue;
            }
            for (MonitorTriggerInsModel ins : insList) {
                ruleOpsDtoList.add(this.buildRuleOpsDto(ruleModel, triggerModel, ins));
            }
        }
        return ruleOpsDtoList;
    }

    private RuleOpsDto buildRuleOpsDto(MonitorRuleModel rule, MonitorTriggerModel trigger, MonitorTriggerInsModel ins) {
        RuleOpsDto ruleOpsDto = new RuleOpsDto(rule, trigger, ins);
        this.fillMonitorRecordInfo(ruleOpsDto);
        return ruleOpsDto;
    }

    private void fillMonitorRecordInfo(RuleOpsDto ruleOpsDto) {
        MonitorRuleModel rule = ruleOpsDto.getRuleModel();
        String eocCompanyId = rule.getEocCompanyId();
        String eocSiteId = rule.getEocSiteId();
        if (null != ruleOpsDto.getIns()) {
            eocCompanyId = ruleOpsDto.getIns().getEocCompanyId();
            eocSiteId = ruleOpsDto.getIns().getEocSiteId();
        }
        MonitorRecordModel recordModel = this.recordService.getLastByRule(rule.getRuleId(), rule.getTenantId(), eocCompanyId, eocSiteId);
        ruleOpsDto.setRecordModel(recordModel);
    }
}

