/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.exception.ArgumentValidException;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.exception.RollbackException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.CrossLevelDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.TriggerRepDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.detection.data.IDupDataCacheFacadeService;
import com.digiwin.athena.cdme.service.facade.eoc.IMatchFacadeService;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.AbstractCreateRuleService;
import com.digiwin.athena.cdme.service.facade.rulesync.ICrossLevelCreateFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ILockService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cdmeCrossLevelCreateFacadeService")
public class CrossLevelCreateFacadeService
extends AbstractCreateRuleService
implements ICrossLevelCreateFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrossLevelCreateFacadeService.class);
    private final IMatchFacadeService eocMatchService;
    private final IDupDataCacheFacadeService dupDataCacheFacadeService;
    private final IScheduleClient scheduleClient;
    private final ILockService lockService;

    public CrossLevelCreateFacadeService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IThemeMapClient themeMapClient, IDupDataCacheFacadeService dupDataCacheFacadeService, IScheduleClient scheduleClient, IMatchFacadeService eocMatchService, ILockService lockService) {
        super(ruleTriggerOperatorFacadeService, themeMapClient);
        this.dupDataCacheFacadeService = dupDataCacheFacadeService;
        this.scheduleClient = scheduleClient;
        this.eocMatchService = eocMatchService;
        this.lockService = lockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="dw-transactionManager")
    public ResultDto syncCrossLevelRule(CrossLevelDto crossLevelDto) {
        if (CollectionUtil.isEmpty(crossLevelDto.getNewEocList())) {
            throw new ArgumentValidException(ErrorCodeEnum.CROSS_LEVEL_NEW_EOC_EMPTY);
        }
        MonitorRuleDto ruleDto = this.getRelativeRuleInfo(crossLevelDto);
        ResultDto<String> statusResult = this.disableIfSrcScheduleEnable(ruleDto);
        if (MonitorHelper.isResultFail(statusResult)) {
            throw new BusinessException(statusResult.getCode(), statusResult.getMessage());
        }
        RLock lock = this.lockService.lock(MonitorHelper.buildLockKey(ruleDto.getRuleModel()), MonitorHelper.buildOldLockKey(ruleDto.getRuleModel()));
        try {
            this.syncCrossLevelRule(crossLevelDto, ruleDto, statusResult.getData());
            ResultDto deleteScheduleResult = this.scheduleClient.deleteSchedule(ruleDto.getTriggerId(), ruleDto.getTenantId());
            if (MonitorHelper.isResultFail(deleteScheduleResult)) {
                throw new BusinessException(deleteScheduleResult.getCode(), deleteScheduleResult.getMessage());
            }
            ResultDto resultDto = ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage());
            return resultDto;
        }
        finally {
            this.lockService.unlock((Lock)lock);
        }
    }

    private ResultDto syncCrossLevelRule(CrossLevelDto crossLevelDto, MonitorRuleDto ruleDto, String scheduleStatus) {
        String ruleId = crossLevelDto.getRuleId();
        String tenantId = crossLevelDto.getTenantId();
        EocDto oldEoc = crossLevelDto.getEocMap();
        List<EocDto> newEocs = crossLevelDto.getNewEocList();
        LOGGER.info("\u8de8\u5c42\u7ea7\u6279\u91cf\u521b\u5efa\u4fa6\u6d4b\u89c4\u5219\u5165\u53c2:ruleId:{}, tenantId:{}, eocMap:{}", new Object[]{ruleId, tenantId, JsonUtil.getJsonString(newEocs)});
        HashMap<String, JSONArray> cacheMap = new HashMap<String, JSONArray>();
        List<TriggerRepDto> triggerRepDtos = new ArrayList<TriggerRepDto>();
        try {
            List<MonitorTriggerInsModel> insModels = this.ruleTriggerOperatorFacadeService.queryTriggerInsByTriggerId(ruleDto.getRuleModel().getTriggerId());
            triggerRepDtos = this.eocMatchService.processEocMatchIns(newEocs, insModels, ruleDto.getRuleModel());
            for (TriggerRepDto triggerRepDto : triggerRepDtos) {
                if (null == triggerRepDto.getIns()) continue;
                String redisKey = MonitorHelper.buildRedisKey(tenantId, ruleId, triggerRepDto.getIns().getEocCompanyId(), triggerRepDto.getIns().getEocSiteId(), ruleDto.getRuleModel().getProductName());
                cacheMap.put(redisKey, this.dupDataCacheFacadeService.getDupData(redisKey));
            }
            this.removeRule(ruleDto, oldEoc, triggerRepDtos);
            ArrayList<MonitorRuleDto> batchRules = new ArrayList<MonitorRuleDto>();
            for (TriggerRepDto triggerRepDto : triggerRepDtos) {
                if (null != triggerRepDto.getIns()) {
                    String redisKey = MonitorHelper.buildRedisKey(tenantId, ruleId, triggerRepDto.getIns().getEocCompanyId(), triggerRepDto.getIns().getEocSiteId(), ruleDto.getRuleModel().getProductName());
                    batchRules.add(this.createMonitorRule(ruleDto.getRuleModel(), triggerRepDto, (JSONArray)cacheMap.get(redisKey), scheduleStatus));
                    continue;
                }
                batchRules.add(this.createMonitorRule(ruleDto.getRuleModel(), triggerRepDto, null, scheduleStatus));
            }
            ResultDto resultDto = this.scheduleClient.createSchedule(batchRules, scheduleStatus);
            if (MonitorHelper.isResultFail(resultDto)) {
                LOGGER.error("\u6279\u91cf\u521b\u5efa\u6392\u7a0b\u5931\u8d25\uff0c\u56de\u6eda\u6570\u636e\uff01");
                throw new RollbackException(resultDto.getCode(), resultDto.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8de8\u5c42\u7ea7\u66f4\u65b0\u89c4\u5219\u5931\u8d25\uff0c\u63d2\u5165\u8001\u7f13\u5b58\u6570\u636e\uff0c\u6062\u590d\u6392\u7a0b\u72b6\u6001\uff0c\u56de\u6eda\u6570\u636e\uff01", (Throwable)e);
            this.processRollback(ruleDto, cacheMap, scheduleStatus, triggerRepDtos);
            throw e;
        }
        return ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage());
    }

    private MonitorRuleDto createMonitorRule(MonitorRuleModel ruleModel, TriggerRepDto triggerRepDto, JSONArray cache, String scheduleStatus) {
        String ruleId = ruleModel.getRuleId();
        String tenantId = ruleModel.getTenantId();
        ResultDto<MonitorRuleDto> saveResult = this.saveRule(tenantId, triggerRepDto.getEocDto(), ruleId, scheduleStatus);
        if (MonitorHelper.isResultFail(saveResult)) {
            throw new BusinessException(saveResult.getCode(), saveResult.getMessage());
        }
        if (null != cache) {
            this.replicateCache(saveResult.getData().getRuleModel(), triggerRepDto.getEocDto(), cache);
        }
        if (null != triggerRepDto.getIns()) {
            this.replicateTriggerIns(triggerRepDto, saveResult.getData().getTriggerModel());
        }
        LOGGER.info("\u8de8\u5c42\u7ea7\u521b\u5efa\u4fa6\u6d4b\u89c4\u5219\u6210\u529f\uff0cruleId:{}, tenantId:{}, eocMap:{}", new Object[]{ruleId, tenantId, JsonUtil.getJsonString(triggerRepDto.getEocDto())});
        return saveResult.getData();
    }

    private void replicateCache(MonitorRuleModel ruleModel, EocDto eocDto, JSONArray cache) {
        String cacheKey = this.getCacheKey(ruleModel.getRuleId(), ruleModel.getTenantId(), ruleModel.getProductName(), eocDto);
        this.dupDataCacheFacadeService.saveDupData(ruleModel, eocDto, cacheKey, cache);
    }

    private void replicateTriggerIns(TriggerRepDto triggerRepDto, MonitorTriggerModel triggerModel) {
        LocalDateTime lastLastMonitorTime = triggerRepDto.getIns().getLastMonitorTime();
        MonitorTriggerInsModel newTriggerInsModel = new MonitorTriggerInsModel(triggerModel.getId(), triggerRepDto.getEocDto().getEocCompanyId(), triggerRepDto.getEocDto().getEocSiteId(), lastLastMonitorTime != null ? lastLastMonitorTime : triggerModel.getCreateTime());
        this.ruleTriggerOperatorFacadeService.saveTriggerIns(newTriggerInsModel);
    }

    private void processRollback(MonitorRuleDto ruleDto, Map<String, JSONArray> cacheMap, String scheduleStatus, List<TriggerRepDto> triggerRepDtos) {
        cacheMap.forEach((k, v) -> this.dupDataCacheFacadeService.cacheDupData((String)k, (JSONArray)v));
        for (TriggerRepDto triggerRepDto : triggerRepDtos) {
            String cacheKey = this.getCacheKey(ruleDto.getRuleModel().getRuleId(), ruleDto.getRuleModel().getTenantId(), ruleDto.getRuleModel().getProductName(), triggerRepDto.getEocDto());
            boolean isSuccess = this.dupDataCacheFacadeService.deleteCacheByKey(cacheKey);
            if (isSuccess) continue;
            LOGGER.error("CrossLevelCreateService\u5220\u9664\u65b0\u589eredis\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01");
        }
        if ("Y".equals(scheduleStatus)) {
            this.scheduleClient.createSchedule(Collections.singletonList(ruleDto), scheduleStatus);
        }
    }

    private String getCacheKey(String ruleId, String tenantId, String productName, EocDto eocDto) {
        return MonitorHelper.buildCrossLevelRedisKey(new MonitorRuleModel(ruleId, tenantId, productName), eocDto);
    }

    protected void removeRule(MonitorRuleDto ruleDto, EocDto eocDto, List<TriggerRepDto> triggerRepDtos) {
        this.ruleTriggerOperatorFacadeService.deleteRule(ruleDto, eocDto);
        for (TriggerRepDto triggerRepDto : triggerRepDtos) {
            if (null == triggerRepDto.getIns()) continue;
            this.dupDataCacheFacadeService.cleanDeduplicateData(ruleDto.getRuleModel(), triggerRepDto);
        }
    }

    private MonitorRuleDto getRelativeRuleInfo(CrossLevelDto crossLevelDto) {
        MonitorRuleDto ruleDto = this.ruleTriggerOperatorFacadeService.queryRuleDetailByRuleId(crossLevelDto.getRuleId(), crossLevelDto.getTenantId(), crossLevelDto.getEocMap());
        MonitorRuleModel ruleModel = ruleDto.getRuleModel();
        if (null == ruleModel || StringUtil.isBlank(ruleModel.getMonitorRule())) {
            throw new BusinessException(ErrorCodeEnum.RULE_NOT_EXISTS);
        }
        if ("cdmeREPORT".equals(ruleModel.getCategory())) {
            throw new BusinessException(ErrorCodeEnum.CROSS_LEVEL_UNSUPPORTED_REPORT);
        }
        if (null == ruleDto.getTriggerModel()) {
            throw new BusinessException(ErrorCodeEnum.TRIGGER_NOT_EXISTS);
        }
        return ruleDto;
    }

    private ResultDto<String> disableIfSrcScheduleEnable(MonitorRuleDto ruleDto) {
        ResultDto scheduleResult;
        ResultDto<String> statusResult = this.scheduleClient.getScheduleStatus(ruleDto.getRuleModel().getTriggerId(), ruleDto.getRuleModel().getTenantId(), DWServiceContext.getContext().getToken());
        if (MonitorHelper.isResultFail(statusResult)) {
            return statusResult;
        }
        if ("Y".equals(statusResult.getData()) && MonitorHelper.isResultFail(scheduleResult = this.scheduleClient.stopSchedule(ruleDto.getTriggerId(), ruleDto.getTenantId()))) {
            return scheduleResult;
        }
        return ResultHelper.generateResult(true, "", statusResult.getData());
    }
}

