/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.core.enums.Category;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.ISyncFacadeService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cdmeMODIFIED")
public class ModifyService
implements ISyncFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifyService.class);
    private final IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;
    private final IThemeMapClient themeMapClient;

    public ModifyService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IScheduleClient scheduleClient, IThemeMapClient themeMapClient) {
        this.ruleTriggerOperatorFacadeService = ruleTriggerOperatorFacadeService;
        this.themeMapClient = themeMapClient;
    }

    @Override
    @Transactional(value="dw-transactionManager")
    public ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto) {
        LOGGER.info("\u4fee\u6539CDC\u4fa6\u6d4b\u89c4\u5219\u5165\u53c2:{}", (Object)ruleDto);
        MonitorCdcRuleDto monitorRuleDtoOld = this.ruleTriggerOperatorFacadeService.getByRuleIdAndTenantIdAndEocUnStatus(ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getEocMap());
        ResultDto<Void> validResult = this.validRuleExists(monitorRuleDtoOld);
        if (MonitorHelper.isResultFail(validResult)) {
            return validResult;
        }
        if (Category.CDC.toString().equals(monitorRuleDtoOld.getRuleModel().getCategory()) && monitorRuleDtoOld.getRuleModel() != null && StringUtils.equals((CharSequence)monitorRuleDtoOld.getRuleModel().getValid(), (CharSequence)"DISABLED")) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.RULE_NOT_EXISTS, new Object[0]);
        }
        MonitorCdcRuleDto monitorCdcRuleDto = this.themeMapClient.getCdcRuleInfo(ruleDto.getTenantId(), ruleDto.getEocMap(), ruleDto.getRuleId());
        MonitorRuleCdcModel currentRule = monitorCdcRuleDto.getRuleModel();
        if (Category.MQTT.toString().equals(monitorRuleDtoOld.getRuleModel().getCategory())) {
            if (StringUtils.equals((CharSequence)ruleDto.getEnableStatus(), (CharSequence)"Y")) {
                currentRule.setValid("ENABLED");
            } else if (StringUtils.equals((CharSequence)ruleDto.getEnableStatus(), (CharSequence)"N")) {
                currentRule.setValid("DISABLED");
            }
            if (!monitorRuleDtoOld.getRuleModel().getDbName().equals(currentRule.getDbName()) || !monitorRuleDtoOld.getRuleModel().getTableName().equals(currentRule.getTableName())) {
                throw new BusinessException("MQTT\u4fa6\u6d4b\u7684\u4e3b\u9898\u548c\u4e3b\u9898\u6765\u6e90\u4e0d\u5141\u8bb8\u4fee\u6539");
            }
        }
        this.processRuleModel(currentRule, monitorRuleDtoOld);
        this.ruleTriggerOperatorFacadeService.modifyCdcRule(monitorCdcRuleDto);
        LOGGER.info("\u4fee\u6539CDC\u4fa6\u6d4b\u89c4\u5219\u6210\u529f");
        return ResultHelper.generateResult(ResultEnum.RULE_SCHEDULE_SUCCESS);
    }

    private void processRuleModel(MonitorRuleCdcModel currentRule, MonitorCdcRuleDto monitorRuleDtoOld) {
        currentRule.setKid(monitorRuleDtoOld.getRuleModel().getKid());
        currentRule.setUpdateTime(LocalTimeUtil.now());
    }
}

