/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.srp.cache.impl;

import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.service.srp.cache.ILockService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="cdmeDistributeLockService")
public class DistributeLockService
implements ILockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributeLockService.class);
    @Autowired
    @Qualifier(value="cdmeRedissonClient")
    private RedissonClient redissonClient;

    @Override
    public Lock lock(String lockKey) {
        Object lock;
        lockKey = "monitorengine:" + lockKey;
        try {
            lock = this.redissonClient.getLock(lockKey);
            lock.lock();
            LOGGER.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff0c\u9501\u540d\u79f0\uff1a[{}]", (Object)lockKey);
        }
        catch (RedisException e) {
            LOGGER.error("\u83b7\u53d6\u9501\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01\u9501\u540d\u79f0: " + lockKey, (Throwable)e);
            lock = new CustomLock();
            lock.lock();
            lock.unlock();
        }
        return lock;
    }

    @Override
    public RLock lock(String lockKey, String oldKey) {
        RLock lock = this.redissonClient.getLock(oldKey);
        if (lock.isLocked()) {
            return lock;
        }
        lockKey = "monitorengine:" + lockKey;
        lock = this.redissonClient.getLock(lockKey);
        lock.lock();
        LOGGER.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff0c\u9501\u540d\u79f0\uff1a[{}]", (Object)lockKey);
        return lock;
    }

    @Override
    public void unlock(Lock lock) {
        try {
            lock.unlock();
            if (lock instanceof RLock) {
                LOGGER.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff0c\u9501\u540d\u79f0\uff1a[{}]", (Object)((RLock)lock).getName());
            } else {
                LOGGER.info("\u91ca\u653e\u81ea\u5b9a\u4e49\u9501\u6210\u529f");
            }
        }
        catch (RedisException e) {
            if (lock instanceof RLock) {
                LOGGER.error("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0c\u9501\u540d\u79f0\uff1a[" + ((RLock)lock).getName() + "]", (Throwable)e);
            }
            LOGGER.error("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01", (Throwable)e);
        }
    }

    public static class CustomLock
    implements Lock {
        @Override
        public void lock() {
            LOGGER.info("\u81ea\u5b9a\u4e49lock\u64cd\u4f5c\uff0c\u65e0\u5b9e\u9645\u610f\u4e49\uff01");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new BusinessException("CustomLock\u4e2d\u4e0d\u652f\u6301lockInterruptibly\u64cd\u4f5c\uff01");
        }

        @Override
        public boolean tryLock() {
            throw new BusinessException("CustomLock\u4e2d\u4e0d\u652f\u6301tryLock\u64cd\u4f5c\uff01");
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new BusinessException("CustomLock\u4e2d\u4e0d\u652f\u6301tryLock()\u64cd\u4f5c\uff01");
        }

        @Override
        public void unlock() {
            LOGGER.info("\u81ea\u5b9a\u4e49unlock\u64cd\u4f5c\uff0c\u65e0\u5b9e\u9645\u610f\u4e49\uff01");
        }

        @Override
        public Condition newCondition() {
            return null;
        }
    }
}

