/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorRuleCdcMapper;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import com.digiwin.athena.cdme.service.srp.db.IMqttServerConfigService;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorRuleCdcService")
public class MonitorRuleCdcService
extends AbstractRepositorService<CdmeMonitorRuleCdcMapper, MonitorRuleCdcModel>
implements IMonitorRuleCdcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorRuleCdcService.class);
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private IMqttServerConfigService mqttServerConfigService;

    public MonitorRuleCdcService(CdmeMonitorRuleCdcMapper mapper) {
        super(mapper);
    }

    @Override
    public List<MonitorRuleCdcModel> getByTenantIdAndTableAndChangeType(String tenantId, String tableName, String changeType) {
        return ((CdmeMonitorRuleCdcMapper)this.mapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MonitorRuleCdcModel::getTenantId, (Object)tenantId)).eq(MonitorRuleCdcModel::getTableName, (Object)tableName)).eq(MonitorRuleCdcModel::getChangeType, (Object)changeType));
    }

    @Override
    public List<MonitorRuleCdcModel> getByTenantSidAndTableAndChangeType(String tenantSid, String tableName, String changeType) {
        return ((CdmeMonitorRuleCdcMapper)this.mapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MonitorRuleCdcModel::getTenantSid, (Object)tenantSid)).eq(MonitorRuleCdcModel::getTableName, (Object)tableName)).eq(MonitorRuleCdcModel::getChangeType, (Object)changeType));
    }

    @Override
    public List<MonitorRuleCdcModel> listByRuleIdAndTenantId(String ruleId, String tenantId) {
        return ((CdmeMonitorRuleCdcMapper)this.mapper).selectList((Wrapper)this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId));
    }

    @Override
    public List<MonitorRuleCdcModel> getAllRules() {
        return ((CdmeMonitorRuleCdcMapper)this.mapper).selectList((Wrapper)Wrappers.query());
    }

    @Override
    public List<MonitorRuleCdcModel> getByCategory(String category, String dbName) {
        return ((CdmeMonitorRuleCdcMapper)this.mapper).selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MonitorRuleCdcModel::getCategory, (Object)category)).eq(MonitorRuleCdcModel::getDbName, (Object)dbName));
    }

    @Override
    public List<MonitorRuleCdcModel> getListByCategory(String category) {
        return ((CdmeMonitorRuleCdcMapper)this.mapper).selectList((Wrapper)Wrappers.lambdaQuery().eq(MonitorRuleCdcModel::getCategory, (Object)category));
    }

    @Override
    public List<MonitorRuleCdcModel> getDbNameListByCategory(String category) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"distinct db_name"});
        LambdaQueryWrapper distinctDbName = (LambdaQueryWrapper)queryWrapper.lambda().eq(MonitorRuleCdcModel::getCategory, (Object)category);
        return ((CdmeMonitorRuleCdcMapper)this.mapper).selectList((Wrapper)distinctDbName);
    }

    @Override
    public void queryCdcRuleByTenantIdAndTableAndOp(List<MonitorRuleCdcModel> monitorRuleCdcModelList, String tenantId, String db, String tableName, String changeType) {
        String cdcRuleKey;
        String string = cdcRuleKey = this.mqttServerConfigService.getbusinessSourcesList().contains(db) ? MonitorHelper.buildCdcRuleKey(tenantId, db, tableName, changeType) : MonitorHelper.buildCdcRuleKey(tenantId, "", tableName, changeType);
        if (this.cacheService.hasKey(cdcRuleKey)) {
            LOGGER.info("\u6709\u7f13\u5b58\uff0c\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u89c4\u5219\uff0ctenantId={}, tableName={}, changeType={}\uff0ccdcRuleKey={}", new Object[]{tenantId, tableName, changeType, cdcRuleKey});
            Map<Object, Object> cdcRuleList = this.cacheService.hGetAll(cdcRuleKey);
            for (Map.Entry<Object, Object> entry : cdcRuleList.entrySet()) {
                MonitorRuleCdcModel monitorRuleCdcModel = JsonUtil.getObject(String.valueOf(entry.getValue()), MonitorRuleCdcModel.class);
                monitorRuleCdcModelList.add(monitorRuleCdcModel);
            }
        } else {
            LOGGER.info("\u6ca1\u6709\u7f13\u5b58\uff0c\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u89c4\u5219\uff0c\uff0ctenantId={}, tableName={}, changeType={}", new Object[]{tenantId, tableName, changeType});
            monitorRuleCdcModelList = this.getByTenantIdAndTableAndChangeType(tenantId, tableName, changeType);
            if (CollectionUtils.isNotEmpty(monitorRuleCdcModelList)) {
                monitorRuleCdcModelList.forEach(rule -> {
                    String subKey = MonitorHelper.buildCdcRuleSubKey(rule);
                    this.cacheService.hPut(cdcRuleKey, subKey, JsonUtil.getJsonString(rule));
                });
            }
        }
    }

    @Override
    public boolean deleteByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        int result = ((CdmeMonitorRuleCdcMapper)this.mapper).delete((Wrapper)this.queryWrapperByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto));
        if (result < 1) {
            LOGGER.error("sd_monitor_rule_cdc\u8868\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u6761\u4ef6ruleId:{},tenantId:{},eoc:{}", new Object[]{ruleId, tenantId, eocDto});
            return false;
        }
        return true;
    }

    @Override
    public MonitorRuleCdcModel getByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        LambdaQueryWrapper<MonitorRuleCdcModel> wrapper = this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId);
        if (StringUtil.isBlank(eocCompanyId)) {
            wrapper.isNull(MonitorRuleCdcModel::getEocCompanyId);
        } else {
            wrapper.eq(MonitorRuleCdcModel::getEocCompanyId, (Object)eocCompanyId);
        }
        if (StringUtil.isBlank(eocSiteId)) {
            wrapper.isNull(MonitorRuleCdcModel::getEocSiteId);
        } else {
            wrapper.eq(MonitorRuleCdcModel::getEocSiteId, (Object)eocSiteId);
        }
        wrapper.eq(MonitorRuleCdcModel::getValid, (Object)"ENABLED");
        return (MonitorRuleCdcModel)((CdmeMonitorRuleCdcMapper)this.mapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public MonitorRuleCdcModel getByRuleIdAndTenantIdAndEocUnStatus(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        LambdaQueryWrapper<MonitorRuleCdcModel> wrapper = this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId);
        if (StringUtil.isBlank(eocCompanyId)) {
            wrapper.isNull(MonitorRuleCdcModel::getEocCompanyId);
        } else {
            wrapper.eq(MonitorRuleCdcModel::getEocCompanyId, (Object)eocCompanyId);
        }
        if (StringUtil.isBlank(eocSiteId)) {
            wrapper.isNull(MonitorRuleCdcModel::getEocSiteId);
        } else {
            wrapper.eq(MonitorRuleCdcModel::getEocSiteId, (Object)eocSiteId);
        }
        return (MonitorRuleCdcModel)((CdmeMonitorRuleCdcMapper)this.mapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public MonitorRuleCdcModel queryCdcRuleDetailByRuleIdAndTenantId(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        LambdaQueryWrapper<MonitorRuleCdcModel> wrapper = this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId);
        if (StringUtil.isBlank(eocCompanyId)) {
            wrapper.isNull(MonitorRuleCdcModel::getEocCompanyId);
        } else {
            wrapper.eq(MonitorRuleCdcModel::getEocCompanyId, (Object)eocCompanyId);
        }
        if (StringUtil.isBlank(eocSiteId)) {
            wrapper.isNull(MonitorRuleCdcModel::getEocSiteId);
        } else {
            wrapper.eq(MonitorRuleCdcModel::getEocSiteId, (Object)eocSiteId);
        }
        return (MonitorRuleCdcModel)((CdmeMonitorRuleCdcMapper)this.mapper).selectOne((Wrapper)wrapper);
    }

    private LambdaQueryWrapper<MonitorRuleCdcModel> queryWrapperByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        return (LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId).eq(StringUtil.isNotBlank(eocCompanyId), MonitorRuleCdcModel::getEocCompanyId, (Object)eocCompanyId)).eq(StringUtil.isNotBlank(eocSiteId), MonitorRuleCdcModel::getEocSiteId, (Object)eocSiteId);
    }

    private LambdaQueryWrapper<MonitorRuleCdcModel> queryWrapperByRuleIdAndTenantId(String ruleId, String tenantId) {
        return (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MonitorRuleCdcModel::getRuleId, (Object)ruleId)).eq(MonitorRuleCdcModel::getTenantId, (Object)tenantId);
    }
}

