package com.digiwin.athena.cdme;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * LocalDateTime返回前台的默认转换类,底层用的是Gson,所以需要使用Gson的扩展实现
 *
 * @author zhangzhi@digiwin.com
 * @date 2020/7/30
 */
public class LocalDateTimeConverter extends TypeAdapter {
    private static final DateTimeFormatter DATETIME_FMT_BY_LINE_AND_COLON = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Override
    public void write(JsonWriter out, Object value) throws IOException {
        out.value(DATETIME_FMT_BY_LINE_AND_COLON.format((LocalDateTime)value));
    }

    @Override
    public Object read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

}
