package com.digiwin.athena.cdme.service.srp.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * @description:
 * @author: dongwh
 * @date: 2021/10/19 15:27
 */
public interface ICacheService {
    /**
     * 是否存在此key
     *
     * @param key
     * @return
     */
    boolean hasKey(String key);

    /**
     * 根据key获取对应的value
     *
     * @param key
     * @param <T>
     * @return
     */
    <T> T get(String key);

    /**
     * 根据key设置对应的value
     *
     * @param key
     * @param value
     */
    void set(String key, Object value);

    /**
     * 根据key设置对应的value
     * @param key
     * @param value
     * @param seconds
     */
    void set(String key, Object value, int seconds);

    /**
     * 根据对应的keys批量删除缓存
     *
     * @param keys
     * @return
     */
    boolean delete(Collection keys);

    /**
     * 返回所有包含keyPattern的key
     *
     * @param keyPattern
     * @return
     */
    Set<String> keys(String keyPattern);

    /**
     * 获取某个key的hash中某个field的值
     * @param key
     * @param field
     * @return
     */
   Object hGet(String key, String field);

    /**
     * 获取key下所有的kv值
     * @param key
     * @return
     */
    Map<Object, Object> hGetAll(String key);

    /**
     * 插入某个key的某个字段的值
     * @param key
     * @param hashKey
     * @param value
     */
    void hPut(String key, Object hashKey, Object value);

    /**
     * 删除某个key的某个子key的值
     * @param key
     * @param hashKey
     * @return
     */
    Long hDelete(String key, Object hashKey);

}
