/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.execution.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ExecuteRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ProcessPageDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.execution.IProcessExecutionService;
import com.digiwin.athena.cdme.service.facade.detection.execution.impl.ActionProxy;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeProcessExecutionService")
public class ProcessExecutionService
implements IProcessExecutionService {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessExecutionService.class);
    private final ActionProxy actionProxy;

    public ProcessExecutionService(ActionProxy actionProxy) {
        this.actionProxy = actionProxy;
    }

    @Override
    public ProcessPageDto processExecutionByPage(ExecuteRequestDto executeRequest, Map<String, JSONObject> allParam) {
        JSONArray changeObjects = executeRequest.getData();
        MonitorRuleModel ruleModel = executeRequest.getRuleModel();
        EocDto eoc = executeRequest.getEocDto();
        List<Object> pageChangeObjects = CollectionUtil.isEmpty((Collection)changeObjects) || changeObjects.size() < ruleModel.getPageSize() ? Collections.singletonList(changeObjects) : Lists.partition((List)changeObjects.toJavaList(JSONObject.class), (int)ruleModel.getPageSize()).stream().map(changes -> JsonUtil.listToJsonArray(changes)).collect(Collectors.toList());
        ProcessPageDto result = new ProcessPageDto(pageChangeObjects.size(), ruleModel.getPageSize());
        pageChangeObjects.stream().forEach(param -> {
            try {
                ResultDto<JSON> executionResult = this.actionProxy.doAction(ruleModel, eoc, (JSONArray)param, allParam);
                if (MonitorHelper.isResultFail(executionResult)) {
                    result.addErrorResponse(executionResult);
                    LOGGER.error("\u5206\u9875\u53d1\u8d77\u884c\u52a8\u5931\u8d25\uff0c\u6570\u636e\u6570\u4e3a\uff1a{}", param);
                } else {
                    result.addSuccessResponse(executionResult.getData());
                    result.addSuccessChangeObjects((JSONArray)param);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5206\u9875\u53d1\u8d77\u884c\u52a8\u8fd4\u56de\u5f02\u5e38\uff0c\u6570\u636e\u6570\u4e3a\uff1a[" + param + "]", (Throwable)e);
                DWRuntimeException runtimeException = e instanceof DWRuntimeException ? (DWRuntimeException)((Object)((Object)e)) : new DWRuntimeException(ErrorCodeEnum.UNKNOW_ERR.getCode(), ErrorCodeEnum.UNKNOW_ERR.getMessage(), (Throwable)e);
                result.addErrorResponse(ResultHelper.generateFailResult(runtimeException.getErrorCode(), null));
            }
        });
        return result;
    }
}

