package com.digiwin.athena.cdme.core.enums;

/**
 * @description: 侦测服务响应结果枚举
 * @author: renwm
 * @date: 2020/4/27 11:07
 */
public enum  ResultEnum {
    /** 规则排程同步处理成功 */
    RULE_SCHEDULE_SUCCESS(2, true, "SUCCESS"),
    /** esp执行规则下发失败 */
    ESP_EXECUTE_FAILED(2, false, "esp执行规则下发失败"),
    /** ACTION侦测回调返回成功 */
    ACTION_SUCCESS(3, true, "ACTION发起回调返回成功"),
    /** ACTION侦测回调返回失败 */
    ACTION_FAILED(4, false, "ACTION发起回调返回失败");

    private final int status;
    private final String message;
    private final boolean isSuccess;

    ResultEnum(int status, boolean isSuccess, String message) {
        this.status = status;
        this.isSuccess = isSuccess;
        this.message = message;
    }

    public int getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    public boolean getSuccess() {
        return isSuccess;
    }
}
