package com.digiwin.athena.cdme.core.thread;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author yang.xiao
 * @version V1.0
 * @Description
 * @date 2024/7/5 18:59
 * @Copyright 鼎捷软件股份有限公司
 */
public class MqttMsgThread implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttMsgThread.class);

    private IMonitorFacadeService monitorFacadeService;

    private JSONObject uniJsonObject;

    private String tenantId;

    private String topicName;

    public MqttMsgThread(IMonitorFacadeService monitorFacadeService, JSONObject uniJsonObject, String tenantId, String topicName) {
        this.monitorFacadeService = monitorFacadeService;
        this.uniJsonObject = uniJsonObject;
        this.tenantId = tenantId;
        this.topicName = topicName;
    }

    @Override
    public void run() {
        ResultDto resultDto = monitorFacadeService.executeDeliver(uniJsonObject);
        if(!resultDto.getSuccess()){
            LOGGER.warn("租户：{}，主题：{}，处理失败：{}", tenantId, topicName, resultDto.getMessage());
        }
    }
}