package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorDupMapper;
import com.digiwin.athena.cdme.repository.model.MonitorDupModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorDupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: dongwh
 * @date: 2022/3/15 15:59
 */
@Service("cdmeMonitorDupService")
public class MonitorDupService extends AbstractRepositorService<CdmeMonitorDupMapper, MonitorDupModel> implements IMonitorDupService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorDupService.class);

    public MonitorDupService(CdmeMonitorDupMapper mapper) {
        super(mapper);
    }

    @Override
    public MonitorDupModel getByRuleIdAndTenantIdAndProdAndEocmap(String ruleId, String tenantId, String productName, EocDto eocDto) {
        return mapper.selectOne(queryWrapperByRuleIdAndTenantIdAndEocmap(ruleId, tenantId, eocDto).eq(MonitorDupModel::getProductName, productName));
    }

    @Override
    public boolean editByRuleIdAndTenantIdAndProdAndEocmap(MonitorDupModel dupModel) {
        String eocCompanyId = dupModel.getEocCompanyId();
        String eocSiteId = dupModel.getEocSiteId();
        int result = mapper.update(null, Wrappers.<MonitorDupModel>lambdaUpdate()
                .eq(MonitorDupModel::getRuleId, dupModel.getRuleId())
                .eq(MonitorDupModel::getTenantId, dupModel.getTenantId())
                .eq(MonitorDupModel::getProductName, dupModel.getProductName())
                .eq(StringUtil.isNotBlank(eocCompanyId), MonitorDupModel::getEocCompanyId, eocCompanyId)
                .eq(StringUtil.isNotBlank(eocSiteId), MonitorDupModel::getEocSiteId, eocSiteId)
                .set(MonitorDupModel::getCacheValue, dupModel.getCacheValue()));
        if (result < 1) {
            LOGGER.error("sd_monitor_dup表更新缓存失败，cacheValue:{}, ruleId:{},tenantId:{},productName:{},eocCompanyId:{},eocSiteId:{}",
                    dupModel.getCacheValue(), dupModel.getRuleId(), dupModel.getTenantId(), dupModel.getProductName(), dupModel.getEocCompanyId(), dupModel.getEocSiteId());
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteByRuleIdAndTenantIdAndEocmap(String ruleId, String tenantId, EocDto eocDto) {
        int result = mapper.delete(queryWrapperByRuleIdAndTenantIdAndEocmap(ruleId, tenantId, eocDto));
        if (result < 1) {
            LOGGER.error("sd_monitor_dup表删除失败，删除条件ruleId:{},tenantId:{},eocDto:{}", ruleId, tenantId, eocDto);
            return false;
        }
        return true;
    }

    /**
     * 查询条件
     *
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    private LambdaQueryWrapper<MonitorDupModel> queryWrapperByRuleIdAndTenantIdAndEocmap(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        return Wrappers.<MonitorDupModel>lambdaQuery()
                .eq(MonitorDupModel::getRuleId, ruleId)
                .eq(MonitorDupModel::getTenantId, tenantId)
                .eq(StringUtil.isNotBlank(eocCompanyId), MonitorDupModel::getEocCompanyId, eocCompanyId)
                .eq(StringUtil.isNotBlank(eocSiteId), MonitorDupModel::getEocSiteId, eocSiteId);
    }
}
